/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.component.menu.AetherMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.client.gui.screen.DynamicMenuButton;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.internal.BrandingControl;

public class AetherTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation AETHER_LOGO = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/title/aether.png");
    public static final Music MENU = new Music(AetherSoundEvents.MUSIC_MENU, 20, 600, true);
    private boolean alignedLeft;
    private int rows;

    public AetherTitleScreen() {
        ((TitleScreenAccessor)((Object)this)).aether$setFading(true);
    }

    public AetherTitleScreen(boolean alignedLeft) {
        this();
        this.alignedLeft = alignedLeft;
    }

    protected void init() {
        super.init();
        this.setupButtons();
    }

    public void setupButtons() {
        int buttonRows = 0;
        int lastY = 0;
        if (((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue()) {
            Component component = ((TitleScreenAccessor)((Object)this)).callGetMultiplayerDisabledReason();
            boolean flag = component == null;
            Tooltip tooltip = component != null ? Tooltip.create((Component)component) : null;
            Button serverButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.aether.menu.server"), button -> {
                ServerData serverData = new ServerData("OATS", "oats.aether-mod.net", ServerData.Type.OTHER);
                ConnectScreen.startConnecting((Screen)this, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false, null);
            }).bounds(this.width / 2 - 100, this.height / 4 + 48 + 72, 200, 20).tooltip(tooltip).build());
            serverButton.active = flag;
            Predicate<AbstractWidget> predicate = abstractWidget -> abstractWidget.getMessage().equals((Object)Component.translatable((String)"menu.multiplayer")) || abstractWidget.getMessage().equals((Object)Component.translatable((String)"menu.online"));
            this.children().removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
            this.renderables.removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
        }
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget2 = (AbstractWidget)renderable;
            Component buttonText = abstractWidget2.getMessage();
            if (TitleScreenBehavior.isImageButton(buttonText)) {
                abstractWidget2.visible = false;
            }
            if (!(abstractWidget2 instanceof AetherMenuButton)) continue;
            AetherMenuButton aetherMenuButton = (AetherMenuButton)abstractWidget2;
            if (this.isAlignedLeft()) {
                ++buttonRows;
            } else if (lastY < aetherMenuButton.originalY) {
                lastY = aetherMenuButton.originalY;
                ++buttonRows;
            }
            if (buttonText.equals((Object)Component.translatable((String)"gui.aether.menu.server"))) {
                aetherMenuButton.serverButton = true;
                aetherMenuButton.buttonCountOffset = 2;
            } else {
                aetherMenuButton.buttonCountOffset = buttonRows;
            }
            if (!((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue() || !buttonText.equals((Object)Component.translatable((String)"menu.singleplayer"))) continue;
            ++buttonRows;
        }
        this.rows = this.alignedLeft ? buttonRows : buttonRows - 1;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)((Object)this);
        if (this.minecraft != null && titleScreenAccessor.aether$getSplash() == null) {
            titleScreenAccessor.aether$setSplash(this.minecraft.getSplashManager().getSplash());
        }
        float fadeAmount = TitleScreenBehavior.super.handleFading(guiGraphics, this, titleScreenAccessor, PANORAMA, PANORAMA_OVERLAY, partialTicks);
        float scale = AetherTitleScreen.getScale(this, this.getMinecraft());
        this.setupLogo(guiGraphics, fadeAmount, scale);
        int roundedFadeAmount = Mth.ceil((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            SplashRendererAccessor splashRendererAccessor;
            ClientHooks.renderMainMenu((TitleScreen)this, (GuiGraphics)guiGraphics, (Font)this.font, (int)this.width, (int)this.height, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null && (splashRendererAccessor = (SplashRendererAccessor)titleScreenAccessor.aether$getSplash()).cumulus$getSplash() != null && !splashRendererAccessor.cumulus$getSplash().isEmpty()) {
                PoseStack poseStack = guiGraphics.pose();
                float splashX = this.alignedLeft ? 400.0f / scale : (float)this.width / 2.0f + 175.0f / scale;
                float splashY = this.alignedLeft ? 100.0f / scale : (float)((int)(20.0f + 76.0f / scale));
                poseStack.pushPose();
                poseStack.translate(splashX, splashY, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-20.0f));
                float textSize = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                textSize = textSize * (200.0f / scale) / ((float)this.font.width(splashRendererAccessor.cumulus$getSplash()) + 64.0f / scale);
                poseStack.scale(textSize, textSize, textSize);
                guiGraphics.drawCenteredString(this.font, splashRendererAccessor.cumulus$getSplash(), 0, (int)(-16.0f / scale), 0xFFFF00 | roundedFadeAmount);
                poseStack.popPose();
            }
            if (this.alignedLeft) {
                TitleScreenBehavior.super.renderRightBranding(guiGraphics, this, this.font, roundedFadeAmount);
            } else {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
                    int n = brandingLine;
                    Objects.requireNonNull(this.font);
                    guiGraphics.drawString(this.font, branding, 2, this.height - (10 + n * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
                BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
                    int n = this.width - this.font.width(branding);
                    int n2 = brandingLine + 1;
                    Objects.requireNonNull(this.font);
                    guiGraphics.drawString(this.font, branding, n, this.height - (10 + n2 * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
            }
        }
        int xOffset = TitleScreenBehavior.super.handleButtonVisibility(this, fadeAmount);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
            if (renderable instanceof AetherMenuButton) {
                AetherMenuButton aetherButton = (AetherMenuButton)renderable;
                if (aetherButton.isMouseOver(mouseX, mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 4;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        TitleScreenBehavior.super.handleImageButtons(this, xOffset);
    }

    private void setupLogo(GuiGraphics guiGraphics, float transparency, float scale) {
        int width = (int)(350.0f / scale);
        int height = (int)(76.0f / scale);
        int logoX = this.alignedLeft ? (int)(10.0f + 18.0f / scale) : (int)((float)(this.width / 2) - 175.0f / scale);
        int logoY = this.alignedLeft ? (int)(15.0f + 10.0f / scale) : (int)(25.0f + 10.0f / scale);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.blit(AETHER_LOGO, logoX, logoY, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static float getScale(AetherTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.getWindow().calculateScale(((Integer)minecraft.options.guiScale().get()).intValue(), minecraft.isEnforceUnicode());
        return AetherTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(AetherTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = AetherMenuButton.totalHeightRange(screen.rows, scale)) > screen.height && scale != 1.0f) {
            return AetherTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((button = (Button)renderable).getMessage())) {
            AetherMenuButton aetherButton = new AetherMenuButton(this, button);
            return (T)super.addRenderableWidget((GuiEventListener)aetherButton);
        }
        return (T)super.addRenderableWidget(renderable);
    }

    public boolean isAlignedLeft() {
        return this.alignedLeft;
    }
}

