/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.construction;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AerogelWallBlock
extends WallBlock {
    private static final Map<Direction, EnumProperty<WallSide>> WALL_SIDES_BY_DIRECTION = new EnumMap<Direction, EnumProperty<WallSide>>(Direction.class);

    public AerogelWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.is((Block)this)) {
            if (side.getAxis().isHorizontal()) {
                WallSide ourHeight = (WallSide)state.getValue((Property)WALL_SIDES_BY_DIRECTION.get(side));
                WallSide theirHeight = (WallSide)adjacentBlockState.getValue((Property)WALL_SIDES_BY_DIRECTION.get(side.getOpposite()));
                return ourHeight.ordinal() <= theirHeight.ordinal();
            }
            return (Boolean)state.getValue((Property)UP) == false || (Boolean)adjacentBlockState.getValue((Property)UP) != false;
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    static {
        WALL_SIDES_BY_DIRECTION.put(Direction.NORTH, (EnumProperty<WallSide>)NORTH_WALL);
        WALL_SIDES_BY_DIRECTION.put(Direction.SOUTH, (EnumProperty<WallSide>)SOUTH_WALL);
        WALL_SIDES_BY_DIRECTION.put(Direction.EAST, (EnumProperty<WallSide>)EAST_WALL);
        WALL_SIDES_BY_DIRECTION.put(Direction.WEST, (EnumProperty<WallSide>)WEST_WALL);
    }
}

