/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.api.integrations.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientType;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.api.integrations.jei.IngredientConverter;

public final class IngredientConverters {
    private static List<IngredientConverter<?>> converters = ImmutableList.of();
    private static Map<IIngredientType<?>, IngredientConverter<?>> convertersByType = ImmutableMap.of();

    private IngredientConverters() {
    }

    public static synchronized boolean register(IngredientConverter<?> converter) {
        for (IngredientConverter<?> existingConverter : converters) {
            if (existingConverter.getIngredientType() != converter.getIngredientType()) continue;
            return false;
        }
        converters = ImmutableList.builder().addAll(converters).add(converter).build();
        convertersByType = converters.stream().collect(Collectors.toMap(IngredientConverter::getIngredientType, c -> c));
        return true;
    }

    public static synchronized List<IngredientConverter<?>> getConverters() {
        return converters;
    }

    @Nullable
    public static synchronized <T> IngredientConverter<T> getConverter(IIngredientType<T> type) {
        IngredientConverter<?> cast = convertersByType.get(type);
        return cast;
    }
}

