/*
 * Decompiled with CFR 0.152.
 */
package com.neuvillette.ae2ct.api;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import com.neuvillette.ae2ct.Config;
import com.neuvillette.ae2ct.api.RecipeHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CraftingTreeHelper {
    private RecipeHelper recipeHelper;
    private List<CraftingPlanSummaryEntry> entries;
    private Map<AEKey, RecipeHelper.Recipe> cache = new HashMap<AEKey, RecipeHelper.Recipe>();
    private Map<AEKey, AmountHelper> amountCache = new HashMap<AEKey, AmountHelper>();
    private Map<Point, Node> nodesMap = new HashMap<Point, Node>();
    private int max_x = 0;
    private int max_y = 0;
    public boolean now_mode = true;

    public CraftingTreeHelper(RecipeHelper recipeHelper, List<CraftingPlanSummaryEntry> entries) {
        this.recipeHelper = recipeHelper;
        this.entries = entries;
    }

    public NodeManager build() {
        if (this.recipeHelper == null) {
            return null;
        }
        this.cache.clear();
        this.nodesMap.clear();
        List<RecipeHelper.Recipe> recipes = this.recipeHelper.recipes;
        for (RecipeHelper.Recipe recipe : recipes) {
            AEKey output = recipe.outputs().getFirst().what();
            if (this.cache.containsKey(output)) continue;
            this.cache.put(output, recipe);
        }
        for (CraftingPlanSummaryEntry entry : this.entries) {
            AEKey key = entry.getWhat();
            if (this.amountCache.containsKey(key)) continue;
            this.amountCache.put(key, new AmountHelper(entry.getMissingAmount(), entry.getStoredAmount(), entry.getCraftAmount()));
        }
        GenericStack output = this.recipeHelper.output;
        long amount = output.amount();
        long outputamount = 0L;
        long times = 0L;
        List<GenericStack> inputs = new ArrayList<GenericStack>();
        for (Map.Entry<AEKey, RecipeHelper.Recipe> entry : this.cache.entrySet()) {
            AEKey k = entry.getKey();
            RecipeHelper.Recipe v = entry.getValue();
            if (!k.equals(output.what())) continue;
            outputamount = v.outputs().getFirst().amount();
            times = amount / outputamount;
            if (amount % outputamount != 0L) {
                ++times;
            }
            inputs = v.inputs();
            break;
        }
        this.max_x = 0;
        this.max_y = 0;
        Node node = this.buildNode(output, amount, inputs, times, outputamount);
        NodeManager nodeManager = new NodeManager(this, node);
        nodeManager.nodeSetPoint(node, new Point(0, 0));
        this.buildNodePosition(node, nodeManager);
        return nodeManager;
    }

    public void buildNodePosition(Node node, NodeManager nodeManager) {
        nodeManager.map.clear();
        if (((Boolean)Config.USE_COMPACT_TREE.get()).booleanValue()) {
            this.now_mode = true;
            this.buildCompactNode(node, nodeManager, new Point(0, 0));
        } else {
            this.now_mode = false;
            this.bulidLooseNode(node, nodeManager, new Point(0, 0), 1);
        }
    }

    public Node buildNode(GenericStack stack, Long amount, List<GenericStack> inputs, long times, long outputamount) {
        if (this.cache == null || this.cache.isEmpty() || this.amountCache == null || this.amountCache.isEmpty()) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        AmountHelper amoCache = this.amountCache.get(stack.what());
        if (amoCache == null) {
            amoCache = new AmountHelper(0L, Long.MAX_VALUE, Long.MAX_VALUE);
        }
        if (inputs.isEmpty()) {
            long storedAmo = AmountHelper.check(amount - amoCache.missingAmount);
            AmountHelper a = new AmountHelper(AmountHelper.check(amount - storedAmo), storedAmo, 0L);
            this.amountCache.put(stack.what(), new AmountHelper(AmountHelper.check(amoCache.missingAmount - amount), amoCache.storedAmount, amoCache.craftAmount));
            Node n = new Node(this, stack, amount, a);
            return n;
        }
        if (times == 0L) {
            AmountHelper a = new AmountHelper(0L, amount, 0L);
            this.amountCache.put(stack.what(), new AmountHelper(amoCache.missingAmount, AmountHelper.check(amoCache.storedAmount - amount), amoCache.craftAmount));
            Node n = new Node(this, stack, amount, a);
            return n;
        }
        for (GenericStack input : inputs) {
            long amo = input.amount() * times;
            long t = 0L;
            long a = 0L;
            List<GenericStack> ins = new ArrayList<GenericStack>();
            for (Map.Entry<AEKey, RecipeHelper.Recipe> entry : this.cache.entrySet()) {
                AEKey k = entry.getKey();
                RecipeHelper.Recipe v = entry.getValue();
                if (!k.equals(input.what())) continue;
                a = v.outputs().getFirst().amount();
                long needcraft = AmountHelper.check(amo - this.amountCache.get((Object)input.what()).storedAmount);
                t = needcraft / a;
                if (needcraft % a != 0L) {
                    ++t;
                }
                ins = v.inputs();
                break;
            }
            Node n = this.buildNode(input, amo, ins, t, a);
            nodes.add(n);
        }
        Node n = new Node(this, stack, amount, new AmountHelper(0L, AmountHelper.check(amount - times * outputamount), times * outputamount), nodes);
        return n;
    }

    public int buildCompactNode(Node node, NodeManager manager, Point initialPoint) {
        int i;
        int len = 0;
        Point p = initialPoint;
        while (manager.map.containsKey(p)) {
            ++len;
            p = new Point(p.x + 1, p.y);
        }
        if (node.subNodes.isEmpty()) {
            manager.nodeSetPoint(node, p);
            return len;
        }
        int addlen = 0;
        int start = 0;
        int end = 0;
        for (i = 0; i < node.subNodes.size(); ++i) {
            Node subNode = node.subNodes.get(i);
            addlen += this.buildCompactNode(subNode, manager, new Point(p.x + i, p.y + 1));
            if (i == 0) {
                p.x += addlen;
                start = subNode.point.x;
                continue;
            }
            if (i != node.subNodes.size() - 1) continue;
            end = subNode.point.x;
        }
        for (i = start; i < end; ++i) {
            if (manager.map.containsKey(new Point(i, p.y + 1))) continue;
            manager.map.put(new Point(i, p.y + 1), null);
        }
        manager.nodeSetPoint(node, p);
        return len;
    }

    public int bulidLooseNode(Node node, NodeManager manager, Point point, int len) {
        int x = point.x + len;
        int y = point.y + 1;
        if (x > this.max_x) {
            this.max_x = x;
        }
        if (y > this.max_y) {
            this.max_y = y;
        }
        int l = 0;
        if (node.subNodes.isEmpty()) {
            manager.nodeSetPoint(node, new Point(x, y));
            return 1;
        }
        for (Node subNode : node.subNodes) {
            l += this.bulidLooseNode(subNode, manager, new Point(x, y), l);
        }
        manager.nodeSetPoint(node, new Point(x, y));
        return l;
    }

    public static class AmountHelper {
        public long missingAmount;
        public long storedAmount;
        public long craftAmount;

        public AmountHelper(long missingAmount, long storedAmount, long craftAmount) {
            this.missingAmount = missingAmount;
            this.storedAmount = storedAmount;
            this.craftAmount = craftAmount;
        }

        public static long check(long a) {
            if (a < 0L) {
                return 0L;
            }
            return a;
        }
    }

    public class Node {
        public GenericStack stack;
        public Long amount;
        public AmountHelper amountHelper;
        public Point point;
        public List<Node> subNodes;

        public Node(CraftingTreeHelper this$0, GenericStack stack, Long amount, AmountHelper amountHelper) {
            this.stack = stack;
            this.amount = amount;
            this.amountHelper = amountHelper;
            this.subNodes = new ArrayList<Node>();
        }

        public Node(CraftingTreeHelper this$0, GenericStack stack, Long amount, AmountHelper amountHelper, List<Node> subNodes) {
            this.stack = stack;
            this.amount = amount;
            this.amountHelper = amountHelper;
            this.subNodes = subNodes;
        }

        public void setPoint(Point p) {
            this.point = p;
        }
    }

    public class NodeManager {
        public Node root;
        int len;
        public Map<Point, Node> map = new HashMap<Point, Node>();
        public int max_x = 0;
        public int max_y = 0;

        public NodeManager(CraftingTreeHelper this$0, Node node) {
            this.root = node;
            this.len = 0;
        }

        public void nodeSetPoint(Node node, Point p) {
            node.setPoint(p);
            this.map.put(p, node);
            if (p.x + 1 > this.max_x) {
                this.max_x = p.x + 1;
            }
            if (p.y + 1 > this.max_y) {
                this.max_y = p.y + 1;
            }
        }
    }
}

