/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityLaserRelayFluids
extends TileEntityLaserRelay {
    public final ConcurrentHashMap<Direction, BlockEntity> handlersAround = new ConcurrentHashMap();
    private final IFluidHandler[] fluidHandlers = new IFluidHandler[6];
    private TileEntityLaserRelayEnergy.Mode mode = TileEntityLaserRelayEnergy.Mode.BOTH;

    public TileEntityLaserRelayFluids(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LASER_RELAY_FLUIDS.getTileEntityType(), pos, state, LaserType.FLUID);
        for (int i = 0; i < this.fluidHandlers.length; ++i) {
            final Direction facing = Direction.values()[i];
            this.fluidHandlers[i] = new IFluidHandler(){

                public int getTanks() {
                    return 0;
                }

                @Nonnull
                public FluidStack getFluidInTank(int tank) {
                    return FluidStack.EMPTY;
                }

                public int getTankCapacity(int tank) {
                    return 0;
                }

                public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                    return false;
                }

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    return TileEntityLaserRelayFluids.this.transmitFluid(facing, resource, action);
                }

                @Nonnull
                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }

                @Nonnull
                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayFluids) {
            TileEntityLaserRelayFluids tile = (TileEntityLaserRelayFluids)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayFluids) {
            TileEntityLaserRelayFluids tile = (TileEntityLaserRelayFluids)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (this.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) {
            for (Direction side : this.handlersAround.keySet()) {
                WorldUtil.doFluidInteraction(this.level, this.handlersAround.get(side).getBlockPos(), this.getBlockPos(), side.getOpposite(), (Integer)CommonConfig.Machines.FLUID_LASER_TRANSFER_RATE.get());
            }
        }
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<Direction, BlockEntity> old = new HashMap<Direction, BlockEntity>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (Direction side : Direction.values()) {
            BlockEntity tile;
            BlockPos pos = this.getBlockPos().relative(side);
            if (!this.level.hasChunkAt(pos) || (tile = this.level.getBlockEntity(pos)) == null || tile instanceof TileEntityLaserRelay || this.level.getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), (Object)side.getOpposite()) == null) continue;
            this.handlersAround.put(side, tile);
            BlockEntity oldTile = (BlockEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.fluidHandlers[facing == null ? 0 : facing.ordinal()];
    }

    private int transmitFluid(Direction from, FluidStack stack, IFluidHandler.FluidAction action) {
        Network network;
        int transmitted = 0;
        if (stack != null && this.mode != TileEntityLaserRelayEnergy.Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferFluidToReceiverInNeed(from, network, stack, action);
        }
        return transmitted;
    }

    private int transferFluidToReceiverInNeed(Direction from, Network network, FluidStack stack, IFluidHandler.FluidAction action) {
        int transmitted = 0;
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        HashSet<TileEntityLaserRelayFluids> relaysThatWork = new HashSet<TileEntityLaserRelayFluids>();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.level.hasChunkAt(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                BlockEntity relayTile = this.level.getBlockEntity(relay);
                if (!(relayTile instanceof TileEntityLaserRelayFluids)) continue;
                TileEntityLaserRelayFluids theRelay = (TileEntityLaserRelayFluids)relayTile;
                if (theRelay.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (Direction facing : theRelay.handlersAround.keySet()) {
                    if (theRelay == this && facing == from) continue;
                    BlockEntity tile = theRelay.handlersAround.get(facing);
                    Direction opp = facing.getOpposite();
                    boolean received = Optional.ofNullable((IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), (Object)opp)).map(cap -> cap.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
                    if (!received) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = stack.getAmount() / totalReceiverAmount > 0 ? stack.getAmount() / totalReceiverAmount : stack.getAmount();
            for (TileEntityLaserRelayFluids theRelay : relaysThatWork) {
                for (Map.Entry<Direction, BlockEntity> receiver : theRelay.handlersAround.entrySet()) {
                    if (receiver == null) continue;
                    Direction side = receiver.getKey();
                    Direction opp = side.getOpposite();
                    BlockEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.getBlockPos())) continue;
                    alreadyChecked.add(tile.getBlockPos());
                    if (theRelay == this && side == from || (transmitted += Optional.ofNullable((IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), (Object)opp)).map(cap -> {
                        int trans = 0;
                        FluidStack copy = stack.copy();
                        copy.setAmount(amountPer);
                        return trans += cap.fill(copy, action);
                    }).orElse(0).intValue()) < stack.getAmount()) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    @Override
    public Component getExtraDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.fluid.extra").append(": ").append((Component)Component.translatable((String)this.mode.name).withStyle(ChatFormatting.DARK_RED));
    }

    @Override
    public Component getCompassDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.energy.display").withStyle(ChatFormatting.GREEN);
    }

    @Override
    public void onCompassAction(Player player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putString("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.getString("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = TileEntityLaserRelayEnergy.Mode.valueOf(modeStrg);
        }
    }
}

