/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.fluids.AATank;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityCoffeeMachine
extends TileEntityInventoryBase
implements MenuProvider,
IButtonReactor,
ISharingFluidHandler {
    public static final int SLOT_COFFEE_BEANS = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int CACHE_USE = 35;
    public static final int ENERGY_USED = 150;
    public static final int WATER_USE = 500;
    public static final int COFFEE_CACHE_MAX_AMOUNT = 300;
    public static final int TIME_USED = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 250, 0);
    public final AATank tank = new AATank(this, 4000){

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public boolean isFluidValid(FluidStack fluid) {
            return fluid.getFluid() == Fluids.WATER;
        }
    };
    public int coffeeCacheAmount;
    public int brewTime;
    private int lastEnergy;
    private int lastTank;
    private int lastCoffeeAmount;
    private int lastBrewTime;

    public TileEntityCoffeeMachine(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.COFFEE_MACHINE.getTileEntityType(), pos, state, 11);
    }

    public int getCoffeeScaled(int i) {
        return this.coffeeCacheAmount * i / 300;
    }

    public int getWaterScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public int getBrewScaled(int i) {
        return this.brewTime * i / 500;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(lookupProvider, compound);
        compound.putInt("Cache", this.coffeeCacheAmount);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("Time", this.brewTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(lookupProvider, compound);
        this.coffeeCacheAmount = compound.getInt("Cache");
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.brewTime = compound.getInt("Time");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoffeeMachine) {
            TileEntityCoffeeMachine tile = (TileEntityCoffeeMachine)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCoffeeMachine) {
            TileEntityCoffeeMachine tile = (TileEntityCoffeeMachine)t;
            tile.serverTick();
            tile.storeCoffee();
            if (tile.brewTime > 0 || tile.isRedstonePowered) {
                tile.brew();
            }
            if ((tile.coffeeCacheAmount != tile.lastCoffeeAmount || tile.storage.getEnergyStored() != tile.lastEnergy || tile.tank.getFluidAmount() != tile.lastTank || tile.brewTime != tile.lastBrewTime) && tile.sendUpdateWithInterval()) {
                tile.lastCoffeeAmount = tile.coffeeCacheAmount;
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastTank = tile.tank.getFluidAmount();
                tile.lastBrewTime = tile.brewTime;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot >= 3 && ItemCoffee.getIngredientRecipeFromStack(stack) != null || slot == 0 && stack.is(ActuallyTags.Items.COFFEE_BEANS) || slot == 1 && stack.getItem() == ActuallyItems.EMPTY_CUP.get();
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 2 || slot >= 3 && slot < this.inv.getSlots() && ItemCoffee.getIngredientRecipeFromStack(this.inv.getStackInSlot(slot)) == null;
    }

    public void storeCoffee() {
        int toAdd;
        if (!this.inv.getStackInSlot(0).isEmpty() && this.inv.getStackInSlot(0).is(ActuallyTags.Items.COFFEE_BEANS) && (toAdd = 2) <= 300 - this.coffeeCacheAmount) {
            this.inv.setStackInSlot(0, StackUtil.shrink(this.inv.getStackInSlot(0), 1));
            this.coffeeCacheAmount += toAdd;
        }
    }

    public void brew() {
        if (this.level.isClientSide) {
            return;
        }
        ItemStack input = this.inv.getStackInSlot(1);
        if (!input.isEmpty() && input.is(ActuallyItems.EMPTY_CUP) && this.inv.getStackInSlot(2).isEmpty() && this.coffeeCacheAmount >= 35 && this.tank.getFluid().getFluid() == Fluids.WATER && this.tank.getFluidAmount() >= 500) {
            if (this.storage.getEnergyStored() >= 150) {
                if (this.brewTime % 30 == 0) {
                    this.level.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)AASounds.COFFEE_MACHINE.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
                ++this.brewTime;
                this.storage.extractEnergyInternal(150, false);
                if (this.brewTime >= 500) {
                    this.brewTime = 0;
                    ItemStack output = new ItemStack((ItemLike)ActuallyItems.COFFEE_CUP.get());
                    for (int i = 3; i < this.inv.getSlots(); ++i) {
                        RecipeHolder<CoffeeIngredientRecipe> recipeHolder;
                        if (this.inv.getStackInSlot(i).isEmpty() || (recipeHolder = ItemCoffee.getIngredientRecipeFromStack(this.inv.getStackInSlot(i))) == null || !((CoffeeIngredientRecipe)recipeHolder.value()).effect(output)) continue;
                        this.inv.setStackInSlot(i, StackUtil.shrinkForContainer(this.inv.getStackInSlot(i), 1));
                    }
                    this.inv.setStackInSlot(2, output.copy());
                    this.inv.getStackInSlot(1).shrink(1);
                    this.coffeeCacheAmount -= 35;
                    this.tank.drainInternal(500, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else {
            this.brewTime = 0;
        }
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0 && this.brewTime <= 0) {
            this.brew();
        }
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.tank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return null;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.coffeeMachine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new ContainerCoffeeMachine(windowId, playerInventory, this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.storage.setEnergyStored((Integer)componentInput.getOrDefault(ActuallyComponents.ENERGY_STORAGE, (Object)0));
        this.tank.setFluid(((ActuallyComponents.FluidContents)componentInput.getOrDefault(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.EMPTY)).get());
        this.coffeeCacheAmount = (Integer)componentInput.getOrDefault(ActuallyComponents.MISC_INT, (Object)0);
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ActuallyComponents.ENERGY_STORAGE, (Object)this.storage.getEnergyStored());
        builder.set(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.of(this.tank.getFluid()));
        builder.set(ActuallyComponents.MISC_INT, (Object)this.coffeeCacheAmount);
    }
}

