/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.lootmodifier.ActuallyLootModifiers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class DungeonLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<DungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> DungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DungeonLootModifier::new)));

    public DungeonLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.getRandom();
        if (((Boolean)CommonConfig.Other.DUNGEON_LOOT.get()).booleanValue()) {
            int count;
            ResourceLocation lootTable = context.getQueriedLootTableId();
            boolean addCrystals = false;
            boolean addDrillCore = false;
            boolean addQuartz = false;
            boolean addBatWings = false;
            if (BuiltInLootTables.SIMPLE_DUNGEON.equals(lootTable)) {
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.ABANDONED_MINESHAFT.equals(lootTable)) {
                addCrystals = true;
                addDrillCore = true;
            } else if (BuiltInLootTables.VILLAGE_WEAPONSMITH.equals(lootTable)) {
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.STRONGHOLD_LIBRARY.equals(lootTable)) {
                addBatWings = true;
            } else if (BuiltInLootTables.IGLOO_CHEST.equals(lootTable)) {
                addBatWings = true;
            } else if (BuiltInLootTables.DESERT_PYRAMID.equals(lootTable)) {
                addDrillCore = true;
                addBatWings = true;
            } else if (BuiltInLootTables.NETHER_BRIDGE.equals(lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
            } else if (BuiltInLootTables.END_CITY_TREASURE.equals(lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.WOODLAND_MANSION.equals(lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            }
            if (addCrystals) {
                Item crystal;
                if (random.nextInt(5) == 0) {
                    count = random.nextInt(3) + 1;
                    crystal = this.getRandomItem(random, ActuallyTags.Items.CRYSTALS, (Item)ActuallyItems.RESTONIA_CRYSTAL.get());
                    generatedLoot.add((Object)new ItemStack((ItemLike)crystal, count));
                }
                if (random.nextInt(15) == 0) {
                    count = random.nextInt(3) + 1;
                    crystal = this.getRandomItem(random, ActuallyTags.Items.CRYSTAL_BLOCKS, (Item)ActuallyBlocks.RESTONIA_CRYSTAL.getItem());
                    generatedLoot.add((Object)new ItemStack((ItemLike)crystal, count));
                }
            }
            if (addDrillCore) {
                System.out.println("Deciding to add drill core or not");
                if (random.nextInt(10) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.DRILL_CORE.get()));
                }
            }
            if (addQuartz && random.nextInt(5) == 0) {
                count = random.nextInt(5) + 1;
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.BLACK_QUARTZ.get(), count));
            }
            if (addBatWings && random.nextInt(10) == 0) {
                count = random.nextInt(2) + 1;
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.BATS_WING.get(), count));
            }
        }
        return generatedLoot;
    }

    private Item getRandomItem(RandomSource random, TagKey<Item> tagKey, Item defaultItem) {
        Holder itemHolder;
        HolderSet.Named holderSet = BuiltInRegistries.ITEM.getTag(tagKey).orElse(null);
        if (holderSet != null && (itemHolder = (Holder)holderSet.getRandomElement(random).orElse(null)) != null) {
            return (Item)itemHolder.value();
        }
        return defaultItem;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return ActuallyLootModifiers.DUNGEON_LOOT.get();
    }
}

