/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LensDisenchanting
extends Lens {
    public static final int ENERGY_USE = 250000;

    @Override
    public boolean invoke(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        List items;
        if (tile.getEnergy() >= 250000 && (items = tile.getWorldObject().getEntitiesOfClass(ItemEntity.class, new AABB((double)hitBlock.getX(), (double)hitBlock.getY(), (double)hitBlock.getZ(), (double)(hitBlock.getX() + 1), (double)(hitBlock.getY() + 1), (double)(hitBlock.getZ() + 1)))) != null && !items.isEmpty()) {
            ItemEntity book = null;
            ItemEntity toDisenchant = null;
            for (ItemEntity item : items) {
                ItemStack stack;
                if (item == null || !item.isAlive() || (stack = item.getItem()).isEmpty() || stack.getCount() != 1) continue;
                Item stackItem = stack.getItem();
                if (stackItem == Items.BOOK || stackItem == Items.ENCHANTED_BOOK) {
                    if (book == null) {
                        book = item;
                        continue;
                    }
                    return false;
                }
                ItemEnchantments enchants = stack.getTagEnchantments();
                if (enchants.isEmpty()) continue;
                if (toDisenchant == null) {
                    toDisenchant = item;
                    continue;
                }
                return false;
            }
            if (book != null && toDisenchant != null) {
                ItemStack disenchantStack = toDisenchant.getItem();
                ItemStack bookStack = book.getItem();
                ItemEnchantments enchants = disenchantStack.getTagEnchantments();
                if (!enchants.isEmpty()) {
                    Holder enchant = (Holder)enchants.keySet().iterator().next();
                    int level = enchants.getLevel(enchant);
                    ItemStack newDisenchantStack = disenchantStack.copy();
                    ItemStack newBookStack = bookStack.getItem() == Items.BOOK ? EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchant, level)) : bookStack.copy();
                    ItemUtil.removeEnchantment(newDisenchantStack, (Holder<Enchantment>)enchant);
                    ItemEntity disenchanted = new ItemEntity(toDisenchant.getCommandSenderWorld(), toDisenchant.getX(), toDisenchant.getY(), toDisenchant.getZ(), newDisenchantStack);
                    ItemEntity newBook = new ItemEntity(book.getCommandSenderWorld(), book.getX(), book.getY(), book.getZ(), newBookStack);
                    toDisenchant.discard();
                    book.discard();
                    tile.getWorldObject().addFreshEntity((Entity)newBook);
                    tile.getWorldObject().addFreshEntity((Entity)disenchanted);
                    tile.extractEnergy(250000);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getColor() {
        return 15445503;
    }

    @Override
    public int getDistance() {
        return 5;
    }

    @Override
    public boolean canInvoke(IAtomicReconstructor tile, Direction sideToShootTo, int energyUsePerShot) {
        return tile.getEnergy() - energyUsePerShot >= 250000;
    }
}

