/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.crafting.PressingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCanolaPress;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ContainerCanolaPress
extends AbstractContainerMenu {
    public final TileEntityCanolaPress press;

    public ContainerCanolaPress(int windowId, Inventory inventory, TileEntityCanolaPress tile) {
        super(ActuallyContainers.CANOLA_PRESS_CONTAINER.get(), windowId);
        int i;
        this.press = tile;
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.press.inv, 0, 81, 10));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
    }

    public static ContainerCanolaPress fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerCanolaPress(windowId, inv, (TileEntityCanolaPress)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = 1;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            Optional<RecipeHolder<PressingRecipe>> recipeOptional;
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? ((recipeOptional = TileEntityCanolaPress.getRecipeForInput(newStack)).isPresent() ? !this.moveItemStackTo(newStack, 0, 1, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.press.canPlayerUse(player);
    }
}

