/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.phys.Vec3;

public class RenderEmpowerer
implements BlockEntityRenderer<TileEntityEmpowerer> {
    public RenderEmpowerer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityEmpowerer tile, float partialTicks, @Nonnull PoseStack matrices, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack stack = tile.inv.getStackInSlot(0);
        if (!stack.isEmpty()) {
            matrices.pushPose();
            matrices.translate(0.5f, 1.0f, 0.5f);
            float boop = (float)Util.getMillis() / 800.0f;
            matrices.translate(0.0, Math.sin((double)boop % (Math.PI * 2)) * 0.065, 0.0);
            matrices.mulPose(Axis.YP.rotationDegrees(boop * 40.0f % 360.0f));
            float scale = stack.getItem() instanceof BlockItem ? 0.85f : 0.65f;
            matrices.scale(scale, scale, scale);
            try {
                AssetUtil.renderItemInWorld(stack, combinedLight, combinedOverlay, matrices, buffer);
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.error("Something went wrong trying to render an item in an empowerer! The item is {}!", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)e);
            }
            matrices.popPose();
        }
        if (tile.getCurrentRecipe() != null) {
            RecipeHolder<EmpowererRecipe> holder = tile.getCurrentRecipe();
            for (int i = 0; i <= 3; ++i) {
                Direction facing = Direction.from2DDataValue((int)i);
                BlockPos offset = new BlockPos(0, 0, 0).relative(facing, 3);
                AssetUtil.renderLaser(matrices, buffer, new Vec3(0.0, 0.0, 0.0), new Vec3((double)offset.getX(), (double)offset.getY() + 0.45, (double)offset.getZ()), 80.0f, ((EmpowererRecipe)holder.value()).getParticleColors(), 1.0f, 0.1f);
            }
        }
    }
}

