/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.blockhuds;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ReconstructorHud
implements IBlockHud {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult) || minecraft.level == null) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile instanceof TileEntityAtomicReconstructor) {
            MutableComponent lens_name;
            TileEntityAtomicReconstructor laser = (TileEntityAtomicReconstructor)tile;
            ItemStack slot = laser.inv.getStackInSlot(0);
            if (slot.isEmpty()) {
                lens_name = Component.translatable((String)"info.actuallyadditions.nolens");
            } else {
                lens_name = slot.getItem().getName(slot);
                AssetUtil.renderStackToGui(slot, resolution.getGuiScaledWidth() / 2 + 15, resolution.getGuiScaledHeight() / 2 - 19, 1.0f);
            }
            guiGraphics.drawString(minecraft.font, lens_name.plainCopy().withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC).getString(), (int)((float)resolution.getGuiScaledWidth() / 2.0f + 35.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f - 15.0f), 0xFFFFFF);
        }
    }
}

