/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class ModRecipeType<Recipe extends ModRecipe>
implements RecipeType<Recipe> {
    private static final List<ModRecipeType<? extends ModRecipe>> s_types = Lists.newLinkedList();
    private final ResourceLocation _id;
    private List<Recipe> _cache;

    public static <Recipe extends ModRecipe> ModRecipeType<Recipe> create(ResourceLocation id) {
        ModRecipeType<Recipe> type = new ModRecipeType<Recipe>(id);
        s_types.add(type);
        return type;
    }

    public static void invalidate() {
        s_types.forEach(ModRecipeType::invalidateCache);
    }

    public ResourceLocation getId() {
        return this._id;
    }

    public List<Recipe> getRecipes() {
        RecipeManager manager;
        if (this._cache.isEmpty() && null != (manager = CodeHelper.getRecipeManager())) {
            List holders = manager.getAllRecipesFor((RecipeType)this);
            ObjectArrayList list = new ObjectArrayList(holders.size());
            holders.forEach(h -> list.add((Object)((ModRecipe)h.value())));
            this._cache = ObjectLists.unmodifiable((ObjectList)list);
        }
        return this._cache;
    }

    public List<Recipe> getRecipes(Predicate<Recipe> filter) {
        return this.stream().filter(filter).collect(Collectors.toList());
    }

    public <R extends Recipe> List<R> getRecipes(Predicate<Recipe> filter, Function<@NotNull Recipe, @NotNull R> mapping) {
        return this.stream().filter(filter).map(mapping::apply).collect(Collectors.toList());
    }

    public Stream<Recipe> stream() {
        return this.getRecipes().stream();
    }

    public Optional<Recipe> findFirst(Predicate<Recipe> predicate) {
        return this.stream().filter(predicate).findFirst();
    }

    public boolean contains(Predicate<Recipe> predicate) {
        return this.stream().anyMatch(predicate);
    }

    public String toString() {
        return this._id.toString();
    }

    protected ModRecipeType(ResourceLocation id) {
        this._id = id;
        this._cache = Collections.emptyList();
    }

    protected void invalidateCache() {
        this._cache = Collections.emptyList();
    }
}

