/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.BiPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements BiPredicate<Ingredient1, Ingredient2> {
    private final RecipeIngredient1 _ingredient1;
    private final RecipeIngredient2 _ingredient2;
    private final RecipeResult _result;

    protected AbstractTwoToOneRecipe(RecipeIngredient1 ingredient1, RecipeIngredient2 ingredient2, RecipeResult result) {
        this._ingredient1 = ingredient1;
        this._ingredient2 = ingredient2;
        this._result = result;
    }

    public static <Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult>> RecipeSerializer<Recipe> createSerializer(String ingredient1FieldName, ModCodecs<RecipeIngredient1, RegistryFriendlyByteBuf> ingredient1Codecs, String ingredient2FieldName, ModCodecs<RecipeIngredient2, RegistryFriendlyByteBuf> ingredient2Codecs, String resultFieldName, ModCodecs<RecipeResult, RegistryFriendlyByteBuf> resultCodecs, Function3<RecipeIngredient1, RecipeIngredient2, RecipeResult, Recipe> recipeFactory) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ingredient1FieldName) ? 1 : 0) != 0, (Object)"Ingredient 1 field name must not be null nor empty");
        Preconditions.checkNotNull(ingredient1Codecs, (Object)"Ingredient 1 codecs must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ingredient2FieldName) ? 1 : 0) != 0, (Object)"Ingredient 2 field name must not be null nor empty");
        Preconditions.checkNotNull(ingredient2Codecs, (Object)"Ingredient 2 codecs must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resultFieldName) ? 1 : 0) != 0, (Object)"Result field name must not be null nor empty");
        Preconditions.checkNotNull(resultCodecs, (Object)"Result codecs must not be null");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory must not be null");
        final MapCodec codec = RecordCodecBuilder.mapCodec(instance -> instance.group(ingredient1Codecs.field(ingredient1FieldName, AbstractTwoToOneRecipe::getIngredient1), ingredient2Codecs.field(ingredient2FieldName, AbstractTwoToOneRecipe::getIngredient2), resultCodecs.field(resultFieldName, AbstractTwoToOneRecipe::getResult)).apply((Applicative)instance, recipeFactory));
        final StreamCodec streamCodec = StreamCodec.composite(ingredient1Codecs.streamCodec(), AbstractTwoToOneRecipe::getIngredient1, ingredient2Codecs.streamCodec(), AbstractTwoToOneRecipe::getIngredient2, resultCodecs.streamCodec(), AbstractTwoToOneRecipe::getResult, recipeFactory);
        return new RecipeSerializer<Recipe>(){

            public MapCodec<Recipe> codec() {
                return codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, Recipe> streamCodec() {
                return streamCodec;
            }
        };
    }

    public RecipeIngredient1 getIngredient1() {
        return this._ingredient1;
    }

    public RecipeIngredient2 getIngredient2() {
        return this._ingredient2;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(Ingredient1 stack1, Ingredient2 stack2) {
        return this.getIngredient1().test(stack1) && this.getIngredient2().test(stack2);
    }

    public NonNullList<Ingredient> getIngredients() {
        return AbstractTwoToOneRecipe.buildVanillaIngredientsList(this.getIngredient1().asVanillaIngredients(), this.getIngredient2().asVanillaIngredients());
    }
}

