/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.network.AbstractPlayPacket;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class AbstractBlockEntityPlayPacket<Packet extends AbstractBlockEntityPlayPacket<Packet>>
extends AbstractPlayPacket<Packet> {
    private final GlobalPos _position;

    public static <B extends ByteBuf, Packet extends AbstractBlockEntityPlayPacket<Packet>, T2> StreamCodec<B, Packet> createStreamCodec(StreamCodec<? super B, T2> codec2, Function<Packet, T2> getter2, BiFunction<GlobalPos, T2, Packet> packetFactory) {
        return StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, AbstractBlockEntityPlayPacket::getPosition, codec2, getter2, packetFactory);
    }

    public static <B extends ByteBuf, Packet extends AbstractBlockEntityPlayPacket<Packet>, T2, T3> StreamCodec<B, Packet> createStreamCodec(StreamCodec<? super B, T2> codec2, Function<Packet, T2> getter2, StreamCodec<? super B, T3> codec3, Function<Packet, T3> getter3, Function3<GlobalPos, T2, T3, Packet> packetFactory) {
        return StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, AbstractBlockEntityPlayPacket::getPosition, codec2, getter2, codec3, getter3, packetFactory);
    }

    public static <B extends ByteBuf, Packet extends AbstractBlockEntityPlayPacket<Packet>, T2, T3, T4> StreamCodec<B, Packet> createStreamCodec(StreamCodec<? super B, T2> codec2, Function<Packet, T2> getter2, StreamCodec<? super B, T3> codec3, Function<Packet, T3> getter3, StreamCodec<? super B, T4> codec4, Function<Packet, T4> getter4, Function4<GlobalPos, T2, T3, T4, Packet> packetFactory) {
        return StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, AbstractBlockEntityPlayPacket::getPosition, codec2, getter2, codec3, getter3, codec4, getter4, packetFactory);
    }

    public static <B extends ByteBuf, Packet extends AbstractBlockEntityPlayPacket<Packet>, T2, T3, T4, T5> StreamCodec<B, Packet> createStreamCodec(StreamCodec<? super B, T2> codec2, Function<Packet, T2> getter2, StreamCodec<? super B, T3> codec3, Function<Packet, T3> getter3, StreamCodec<? super B, T4> codec4, Function<Packet, T4> getter4, StreamCodec<? super B, T5> codec5, Function<Packet, T5> getter5, Function5<GlobalPos, T2, T3, T4, T5, Packet> packetFactory) {
        return StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, AbstractBlockEntityPlayPacket::getPosition, codec2, getter2, codec3, getter3, codec4, getter4, codec5, getter5, packetFactory);
    }

    public static <B extends ByteBuf, Packet extends AbstractBlockEntityPlayPacket<Packet>, T2, T3, T4, T5, T6> StreamCodec<B, Packet> createStreamCodec(StreamCodec<? super B, T2> codec2, Function<Packet, T2> getter2, StreamCodec<? super B, T3> codec3, Function<Packet, T3> getter3, StreamCodec<? super B, T4> codec4, Function<Packet, T4> getter4, StreamCodec<? super B, T5> codec5, Function<Packet, T5> getter5, StreamCodec<? super B, T6> codec6, Function<Packet, T6> getter6, Function6<GlobalPos, T2, T3, T4, T5, T6, Packet> packetFactory) {
        return StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, AbstractBlockEntityPlayPacket::getPosition, codec2, getter2, codec3, getter3, codec4, getter4, codec5, getter5, codec6, getter6, packetFactory);
    }

    protected AbstractBlockEntityPlayPacket(CustomPacketPayload.Type<Packet> type, GlobalPos position) {
        super(type);
        Preconditions.checkNotNull((Object)position, (Object)"Position must not be null");
        this._position = position;
    }

    protected AbstractBlockEntityPlayPacket(CustomPacketPayload.Type<Packet> type, AbstractModBlockEntity blockEntity) {
        this(type, AbstractBlockEntityPlayPacket.positionFrom(blockEntity));
    }

    public GlobalPos getPosition() {
        return this._position;
    }

    public BlockPos getBlockPosition() {
        return this.getPosition().pos();
    }

    public ResourceKey<Level> getDimension() {
        return this.getPosition().dimension();
    }

    protected abstract void processBlockEntity(PacketFlow var1, BlockEntity var2);

    @Override
    public void handlePacket(IPayloadContext context) {
        BlockPos position = this.getBlockPosition();
        CodeHelper.optionalIfPresentOrElse(this.getWorld(context), w -> CodeHelper.optionalIfPresentOrElse(WorldHelper.getTile(w, position), tile -> this.processBlockEntity(context.flow(), (BlockEntity)tile), () -> Log.LOGGER.error(Log.NETWORK, "No tile entity found at {}, {}, {} while processing a ModTileEntityMessage: skipping message", (Object)position.getX(), (Object)position.getY(), (Object)position.getZ())), () -> Log.LOGGER.error(Log.NETWORK, "Invalid world instance found while processing a ModTileEntityMessage: skipping message"));
    }

    private Optional<Level> getWorld(IPayloadContext context) {
        return switch (context.flow()) {
            default -> throw new MatchException(null, null);
            case PacketFlow.CLIENTBOUND -> WorldHelper.getClientWorld();
            case PacketFlow.SERVERBOUND -> WorldHelper.getServerWorld(this.getDimension()).map(serverLevel -> serverLevel);
        };
    }

    private static GlobalPos positionFrom(AbstractModBlockEntity blockEntity) {
        Preconditions.checkNotNull((Object)blockEntity, (Object)"Block entity must not be null");
        Preconditions.checkState((null != blockEntity.getLevel() ? 1 : 0) != 0);
        return new GlobalPos(blockEntity.getLevel().dimension(), blockEntity.getBlockPos());
    }
}

