/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringData
extends AbstractData<String>
implements IContainerData {
    private final StreamCodec<ByteBuf, String> _maxLengthCodec;
    private String _lastValue;

    public static StringData immutable(ModContainer container, int maxLength, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value must not be null.");
        Preconditions.checkArgument((value.length() <= maxLength ? 1 : 0) != 0, (Object)"Value is too big.");
        return StringData.of(container, maxLength, () -> value, CodeHelper.emptyConsumer());
    }

    public static StringData sampled(int frequency, ModContainer container, int maxLength, Supplier<@NotNull String> getter, Consumer<@NotNull String> clientSideSetter) {
        return StringData.of(container, maxLength, new Sampler<String>(frequency, getter), clientSideSetter);
    }

    public static StringData sampled(int frequency, ModContainer container, int maxLength, Supplier<@NotNull String> getter) {
        return StringData.of(container, maxLength, new Sampler<String>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static StringData of(ModContainer container, int maxLength, Supplier<@NotNull String> getter, Consumer<@NotNull String> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        StringData data = container.isClientSide() ? new StringData(maxLength, getter, clientSideSetter) : new StringData(maxLength, getter);
        container.addBindableData(data);
        return data;
    }

    public static StringData of(ModContainer container, int maxLength, Supplier<@NotNull String> getter) {
        return StringData.of(container, maxLength, getter, CodeHelper.emptyConsumer());
    }

    public static StringData of(ModContainer container, int maxLength, String[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return StringData.of(container, maxLength, () -> array[index], v -> {
            array[index] = v;
        });
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        String current = (String)this.getValue();
        if (!this._lastValue.equals(current)) {
            this._lastValue = current;
            return new StringEntry(this._maxLengthCodec, this._lastValue);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return StringEntry.from(this._maxLengthCodec, buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof StringEntry) {
            StringEntry record = (StringEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public String defaultValue() {
        return "";
    }

    private StringData(int maxLength, Supplier<@NotNull String> getter, Consumer<@NotNull String> clientSideSetter) {
        super(getter, clientSideSetter);
        this._maxLengthCodec = ByteBufCodecs.stringUtf8((int)maxLength);
    }

    private StringData(int maxLength, Supplier<@NotNull String> getter) {
        super(getter);
        this._maxLengthCodec = ByteBufCodecs.stringUtf8((int)maxLength);
        this._lastValue = "";
    }

    private record StringEntry(StreamCodec<ByteBuf, String> codec, String value) implements ISyncedSetEntry
    {
        private static StringEntry from(StreamCodec<ByteBuf, String> codec, RegistryFriendlyByteBuf buffer) {
            return new StringEntry(codec, (String)codec.decode((Object)buffer));
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            this.codec.encode((Object)buffer, (Object)this.value);
        }
    }
}

