/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleData
extends AbstractData<Double>
implements IContainerData {
    private double _lastValue;

    public static DoubleData immutable(ModContainer container, double value) {
        return DoubleData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static DoubleData sampled(int frequency, ModContainer container, Supplier<@NotNull Double> getter, Consumer<@NotNull Double> clientSideSetter) {
        return DoubleData.of(container, new Sampler<Double>(frequency, getter), clientSideSetter);
    }

    public static DoubleData sampled(int frequency, ModContainer container, Supplier<@NotNull Double> getter) {
        return DoubleData.of(container, new Sampler<Double>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static DoubleData of(ModContainer container, Supplier<@NotNull Double> getter, Consumer<@NotNull Double> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        DoubleData data = container.isClientSide() ? new DoubleData(getter, clientSideSetter) : new DoubleData(getter);
        container.addBindableData(data);
        return data;
    }

    public static DoubleData of(ModContainer container, double[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return DoubleData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static DoubleData of(ModContainer container, Supplier<@NotNull Double> getter) {
        return DoubleData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        double current = (Double)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new DoubleEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return DoubleEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof DoubleEntry) {
            DoubleEntry record = (DoubleEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Double defaultValue() {
        return 0.0;
    }

    private DoubleData(Supplier<Double> getter, Consumer<Double> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private DoubleData(Supplier<Double> getter) {
        super(getter);
        this._lastValue = 0.0;
    }

    private record DoubleEntry(double value) implements ISyncedSetEntry
    {
        private static DoubleEntry from(RegistryFriendlyByteBuf buffer) {
            return new DoubleEntry(buffer.readDouble());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeDouble(this.value);
        }
    }
}

