/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IEnergySystemAware;
import net.minecraft.network.codec.StreamCodec;

public class WideEnergyStack
implements IEnergySystemAware {
    public static final WideEnergyStack EMPTY = new WideEnergyStack();
    public static final ModCodecs<WideEnergyStack, ByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group(EnergySystem.CODECS.field("system", WideEnergyStack::getEnergySystem), WideAmount.CODECS.field("amount", WideEnergyStack::getAmount)).apply((Applicative)instance, WideEnergyStack::new)), StreamCodec.composite(EnergySystem.CODECS.streamCodec(), WideEnergyStack::getEnergySystem, WideAmount.CODECS.streamCodec(), WideEnergyStack::getAmount, WideEnergyStack::new));
    private final EnergySystem _system;
    private WideAmount _amount;

    public WideEnergyStack(EnergySystem system) {
        this(system, WideAmount.ZERO);
    }

    public WideEnergyStack(EnergySystem system, WideAmount amount) {
        this._system = system;
        this._amount = amount.copy();
    }

    public WideEnergyStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new WideEnergyStack(this._system, this._amount);
    }

    public boolean isEmpty() {
        return EMPTY == this || this._amount.isZero();
    }

    public boolean isEnergySystemEqual(WideEnergyStack other) {
        return this.getEnergySystem() == other.getEnergySystem();
    }

    public static boolean areStacksEqual(WideEnergyStack stackA, WideEnergyStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() && stackA.isStackEqual(stackB);
    }

    public WideAmount getMaxStackSize() {
        return WideAmount.MAX_VALUE;
    }

    public WideAmount getAmount() {
        return this._amount.copy();
    }

    public void setAmount(WideAmount amount) {
        this._amount = this._amount.set(amount);
    }

    public void grow(WideAmount increment) {
        this._amount = this._amount.add(increment);
    }

    public void shrink(WideAmount decrement) {
        this._amount = this._amount.subtract(decrement);
    }

    @Override
    public EnergySystem getEnergySystem() {
        return this._system;
    }

    public String toString() {
        return String.valueOf(this._amount) + " " + String.valueOf((Object)this._system);
    }

    private WideEnergyStack() {
        this._system = EnergySystem.REFERENCE;
        this._amount = WideAmount.ZERO;
    }

    private boolean isStackEqual(WideEnergyStack other) {
        return this._system == other._system && this._amount.equals(other._amount);
    }
}

