/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;

public class WeakReferenceGroup<T> {
    private final ObjectSet<WeakReference<T>> _set;
    private final ReferenceQueue<T> _toBeCollected = new ReferenceQueue();

    public WeakReferenceGroup() {
        this._set = new ObjectArraySet(16);
    }

    public int size() {
        this.purge();
        return this._set.size();
    }

    public boolean isEmpty() {
        this.purge();
        return this._set.isEmpty();
    }

    public WeakReference<T> add(T o) {
        WeakReference<T> ref = new WeakReference<T>(o, this._toBeCollected);
        this._set.add(ref);
        return ref;
    }

    public void remove(WeakReference<T> ref) {
        this._set.remove(ref);
    }

    public void clear() {
        this.purge();
        this._set.clear();
    }

    public List<T> values() {
        ObjectArrayList list = new ObjectArrayList(this.size());
        this._set.forEach(arg_0 -> WeakReferenceGroup.lambda$values$0((ObjectList)list, arg_0));
        return list;
    }

    public void forEach(Consumer<? super T> action) {
        this.values().forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Reference<T> remove;
        while (null != (remove = this._toBeCollected.poll())) {
            ReferenceQueue<T> referenceQueue = this._toBeCollected;
            synchronized (referenceQueue) {
                this._set.remove(remove);
            }
        }
    }

    private static /* synthetic */ void lambda$values$0(ObjectList list, WeakReference ref) {
        list.add(ref.get());
    }
}

