/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage;

import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.zerocore.internal.Log;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.template.TemplateComponent;

public abstract class AbstractStandardPageComponent<PageType extends BookPage>
extends TemplateComponent {
    private final PageType _page;

    protected AbstractStandardPageComponent(PageType page) {
        this._page = page;
    }

    protected PageType getPage() {
        return this._page;
    }

    public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
        this.getPage().build((Level)Minecraft.getInstance().level, entry, builder, pageNum);
    }

    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.getPage().onDisplayed(parent, left, top);
    }

    public void render(GuiGraphics graphics, BookPage page, int mouseX, int mouseY, float partialTicks) {
        if (this.x > 0 || this.y > 0) {
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate((float)this.x, (float)this.y, 0.0f);
            this.renderPage(graphics, mouseX, mouseY, partialTicks);
            stack.popPose();
        } else {
            this.renderPage(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderPage(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.getPage().render(graphics, mouseX, mouseY, partialTicks);
    }

    @Nullable
    protected static <T> Field getField(Class<? super T> clazz, String name) {
        try {
            return ObfuscationReflectionHelper.findField(clazz, (String)name);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
            Log.LOGGER.error(Log.CORE, "patchouli AbstractStandardPageComponent - Unable to get field {} : {}", (Object)name, (Object)ex);
            return null;
        }
    }
}

