/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import java.util.Optional;
import java.util.function.Function;

public class SpriteSet<SpriteId extends Enum<SpriteId>> {
    private final EnumIndexedArray<SpriteId, ISprite> _sprites;
    private final ISprite _default;

    public SpriteSet(SpriteId[] validIds) {
        this(Sprite.EMPTY, (Enum[])validIds);
    }

    public SpriteSet(ISprite defaultSprite, SpriteId[] validIds) {
        this._sprites = new EnumIndexedArray((Function<Integer, Element[]>)((Function<Integer, ISprite[]>)(ISprite[]::new)), validIds);
        this._default = defaultSprite;
    }

    @SafeVarargs
    public SpriteSet(SpriteId firstValidSpriteId, SpriteId secondValidSpriteId, SpriteId ... otherValidIndices) {
        this(Sprite.EMPTY, (Enum)firstValidSpriteId, (Enum)secondValidSpriteId, (Enum[])otherValidIndices);
    }

    @SafeVarargs
    public SpriteSet(ISprite defaultSprite, SpriteId firstValidSpriteId, SpriteId secondValidSpriteId, SpriteId ... otherValidIndices) {
        this._sprites = new EnumIndexedArray(ISprite[]::new, firstValidSpriteId, secondValidSpriteId, otherValidIndices);
        this._default = defaultSprite;
    }

    public Optional<ISprite> get(SpriteId id) {
        return this._sprites.getElement(id);
    }

    public ISprite getOrDefault(SpriteId id) {
        return this._sprites.getElement(id, this._default);
    }

    public ISprite getOrDefault(SpriteId id, ISprite defaultSprite) {
        return this._sprites.getElement(id, defaultSprite);
    }

    public void set(SpriteId id, ISprite sprite) {
        this._sprites.setElement(id, sprite);
    }

    public ISprite getDefaultSprite() {
        return this._default;
    }
}

