/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class FlowLayoutEngine
extends AbstractLayoutEngine<FlowLayoutEngine> {
    @Override
    public void layout(IControlContainer controlsContainer) {
        Rectangle parentBounds = controlsContainer.getBounds();
        int maxWidth = parentBounds.Width - 2 * this.getHorizontalMargin();
        int rowHeight = 0;
        int availableHeight = parentBounds.Height - 2 * this.getVerticalMargin();
        int availableWidth = maxWidth;
        int left = 0;
        int top = this.getVerticalMargin();
        for (IControl control : controlsContainer) {
            int controlWidth = Math.min(maxWidth, this.getControlDesiredDimension(control, DesiredDimension.Width, maxWidth));
            if (controlWidth > availableWidth) {
                left = 0;
                top += rowHeight + this.getControlsSpacing();
                availableWidth = maxWidth;
                availableHeight -= rowHeight + this.getControlsSpacing();
                controlWidth = Math.min(availableWidth, this.getControlDesiredDimension(control, DesiredDimension.Width, availableWidth));
                rowHeight = 0;
            }
            int controlHeight = Math.min(availableHeight, this.getControlDesiredDimension(control, DesiredDimension.Height, availableHeight));
            rowHeight = Math.max(rowHeight, controlHeight);
            control.setBounds(new Rectangle(this.getHorizontalMargin() + left, top, controlWidth, controlHeight));
            left += controlWidth + this.getControlsSpacing();
            availableWidth -= controlWidth + this.getControlsSpacing();
        }
    }
}

