/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.client.gui.AbstractWindowsManager;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Window;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

class WindowsManagerMultiWindow<C extends ModContainer>
extends AbstractWindowsManager<C> {
    private final List<Window<C>> _modelessWindows = Lists.newArrayListWithExpectedSize((int)2);
    private final List<Window<C>> _modalWindows = Lists.newArrayList();
    private Window<C> _interactiveModalWindow = null;

    @Override
    protected void addWindow(Window<C> wnd, boolean isModal) {
        if (isModal) {
            this._modalWindows.add(wnd);
            this._interactiveModalWindow = wnd;
        } else {
            this._modelessWindows.add(wnd);
        }
    }

    @Override
    protected void showWindow(IWindow window, boolean show) {
    }

    @Override
    protected void forEachWindow(Consumer<Window<C>> action) {
        this._modalWindows.forEach(action);
        this._modelessWindows.forEach(action);
    }

    @Override
    protected void forEachInteractiveWindow(Consumer<Window<C>> action) {
        if (null != this._interactiveModalWindow) {
            action.accept(this._interactiveModalWindow);
        } else {
            this._modelessWindows.forEach(action);
        }
    }

    @Override
    @Nullable
    protected <R> R forEachInteractiveWindow(Function<Window<C>, R> transformation, @Nullable R invalidResult) {
        if (null != this._interactiveModalWindow) {
            R result = transformation.apply(this._interactiveModalWindow);
            if (invalidResult != result) {
                return result;
            }
        } else {
            for (Window<C> window : this._modelessWindows) {
                R result = transformation.apply(window);
                if (invalidResult == result) continue;
                return result;
            }
        }
        return invalidResult;
    }

    @Override
    protected Optional<IControl> findControl(int x, int y) {
        if (null != this._interactiveModalWindow) {
            return this._interactiveModalWindow.findControl(x, y);
        }
        for (Window<C> window : this._modelessWindows) {
            Optional<IControl> control = window.findControl(x, y);
            if (!control.isPresent()) continue;
            return control;
        }
        return Optional.empty();
    }

    @Override
    protected void resetState() {
        this._modelessWindows.clear();
        this._modalWindows.clear();
        super.resetState();
    }

    WindowsManagerMultiWindow(ModContainerScreen<C> guiContainer) {
        super(guiContainer);
    }
}

