/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMultiblockEntity<Controller extends AbstractCuboidMultiblockController<Controller>>
extends AbstractCuboidMultiblockPart<Controller> {
    private ModelData _clientModelData;

    public AbstractMultiblockEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected abstract ModelData getUpdatedModelData();

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.addUnlocalized("Model data properties:");
        ModelData data = this.getUpdatedModelData();
        for (ModelProperty property : data.getProperties()) {
            Object value = data.get(property);
            messages.addUnlocalized("- %s = %s", property.toString(), null == value ? "NULL" : value.toString());
        }
    }

    @Override
    public void onPostMachineAssembled(Controller controller) {
        super.onPostMachineAssembled(controller);
        this.updateClientRenderState();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.updateClientRenderState();
    }

    @Override
    public void markForRenderUpdate() {
        this.updateClientRenderState();
        super.markForRenderUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        if (null == this._clientModelData) {
            this._clientModelData = this.getUpdatedModelData();
        }
        return this._clientModelData;
    }

    private void updateClientRenderState() {
        this.callOnLogicalClient(() -> {
            this._clientModelData = null;
            this.requestModelDataUpdate();
            this.notifyBlockUpdate();
        });
    }
}

