/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;

public class BetterMineshaftConfiguration {
    public static final Codec<BetterMineshaftConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("replacementRate").forGetter(config -> Float.valueOf(config.replacementRate)), (App)LegVariant.CODEC.fieldOf("legVariant").forGetter(config -> config.legVariant), (App)MineshaftDecorationChances.CODEC.fieldOf("decorationChances").forGetter(config -> config.decorationChances), (App)MineshaftBlockStates.CODEC.fieldOf("blockStates").forGetter(config -> config.blockStates), (App)MineshaftBlockstateRandomizers.CODEC.fieldOf("blockStateRandomizers").forGetter(config -> config.blockStateRandomizers)).apply((Applicative)instance, BetterMineshaftConfiguration::new));
    public float replacementRate;
    public LegVariant legVariant;
    public MineshaftDecorationChances decorationChances;
    public MineshaftBlockStates blockStates;
    public MineshaftBlockstateRandomizers blockStateRandomizers;

    public BetterMineshaftConfiguration(float replacementRate, LegVariant legVariant, MineshaftDecorationChances decorationChances, MineshaftBlockStates blockStates, MineshaftBlockstateRandomizers blockStateRandomizers) {
        this.replacementRate = replacementRate;
        this.legVariant = legVariant;
        this.decorationChances = decorationChances;
        this.blockStates = blockStates;
        this.blockStateRandomizers = blockStateRandomizers;
    }

    public static enum LegVariant implements StringRepresentable
    {
        EDGE("edge"),
        INNER("inner");

        public static final Codec<LegVariant> CODEC;
        private static final Map<String, LegVariant> BY_NAME;
        private final String name;

        private LegVariant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static LegVariant byName(String name) {
            return BY_NAME.get(name);
        }

        public static LegVariant byId(int id) {
            return id >= 0 && id < LegVariant.values().length ? LegVariant.values()[id] : EDGE;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(LegVariant::values);
            BY_NAME = Arrays.stream(LegVariant.values()).collect(Collectors.toMap(LegVariant::getName, variant -> variant));
        }
    }

    public static class MineshaftDecorationChances {
        public static final Codec<MineshaftDecorationChances> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("vineChance").forGetter(config -> Float.valueOf(config.vineChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("snowChance").forGetter(config -> Float.valueOf(config.snowChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cactusChance").forGetter(config -> Float.valueOf(config.cactusChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("deadBushChance").forGetter(config -> Float.valueOf(config.deadBushChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mushroomChance").forGetter(config -> Float.valueOf(config.mushroomChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("gravelPileChance").forGetter(config -> Float.valueOf(config.gravelPileChance)), (App)Codec.BOOL.fieldOf("lushDecorations").forGetter(config -> config.lushDecorations), (App)Codec.BOOL.fieldOf("dripstoneDecorations").forGetter(config -> config.dripstoneDecorations)).apply((Applicative)instance, MineshaftDecorationChances::new));
        public float vineChance;
        public float snowChance;
        public float cactusChance;
        public float deadBushChance;
        public float mushroomChance;
        public float gravelPileChance;
        public boolean lushDecorations;
        public boolean dripstoneDecorations;

        public MineshaftDecorationChances(float vineChance, float snowChance, float cactusChance, float deadBushChance, float mushroomChance, float gravelPileChance, boolean lushDecorations, boolean dripstoneDecorations) {
            this.vineChance = vineChance;
            this.snowChance = snowChance;
            this.cactusChance = cactusChance;
            this.deadBushChance = deadBushChance;
            this.mushroomChance = mushroomChance;
            this.gravelPileChance = gravelPileChance;
            this.lushDecorations = lushDecorations;
            this.dripstoneDecorations = dripstoneDecorations;
        }
    }

    public static class MineshaftBlockStates {
        public static final Codec<MineshaftBlockStates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("mainBlockState").forGetter(config -> config.mainBlockState), (App)BlockState.CODEC.fieldOf("supportBlockState").forGetter(config -> config.supportBlockState), (App)BlockState.CODEC.fieldOf("slabBlockState").forGetter(config -> config.slabBlockState), (App)BlockState.CODEC.fieldOf("gravelBlockState").forGetter(config -> config.gravelBlockState), (App)BlockState.CODEC.fieldOf("stoneWallBlockState").forGetter(config -> config.stoneWallBlockState), (App)BlockState.CODEC.fieldOf("stoneSlabBlockState").forGetter(config -> config.stoneSlabBlockState), (App)BlockState.CODEC.fieldOf("trapdoorBlockState").forGetter(config -> config.trapdoorBlockState), (App)BlockState.CODEC.fieldOf("smallLegBlockState").forGetter(config -> config.smallLegBlockState)).apply((Applicative)instance, MineshaftBlockStates::new));
        public BlockState mainBlockState;
        public BlockState supportBlockState;
        public BlockState slabBlockState;
        public BlockState gravelBlockState;
        public BlockState stoneWallBlockState;
        public BlockState stoneSlabBlockState;
        public BlockState trapdoorBlockState;
        public BlockState smallLegBlockState;

        public MineshaftBlockStates(BlockState mainBlockState, BlockState supportBlockState, BlockState slabBlockState, BlockState gravelBlockState, BlockState stoneWallBlockState, BlockState stoneSlabBlockState, BlockState trapdoorBlockState, BlockState smallLegBlockState) {
            this.mainBlockState = mainBlockState;
            this.supportBlockState = supportBlockState;
            this.slabBlockState = slabBlockState;
            this.gravelBlockState = gravelBlockState;
            this.stoneWallBlockState = stoneWallBlockState;
            this.stoneSlabBlockState = stoneSlabBlockState;
            this.trapdoorBlockState = trapdoorBlockState;
            this.smallLegBlockState = smallLegBlockState;
        }
    }

    public static class MineshaftBlockstateRandomizers {
        public static final Codec<MineshaftBlockstateRandomizers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateRandomizer.CODEC.fieldOf("mainRandomizer").forGetter(config -> config.mainRandomizer), (App)BlockStateRandomizer.CODEC.fieldOf("floorRandomizer").forGetter(config -> config.floorRandomizer), (App)BlockStateRandomizer.CODEC.fieldOf("brickRandomizer").forGetter(config -> config.brickRandomizer), (App)BlockStateRandomizer.CODEC.fieldOf("legRandomizer").forGetter(config -> config.legRandomizer)).apply((Applicative)instance, MineshaftBlockstateRandomizers::new));
        public BlockStateRandomizer mainRandomizer;
        public BlockStateRandomizer floorRandomizer;
        public BlockStateRandomizer brickRandomizer;
        public BlockStateRandomizer legRandomizer;

        public MineshaftBlockstateRandomizers(BlockStateRandomizer mainRandomizer, BlockStateRandomizer floorRandomizer, BlockStateRandomizer brickRandomizer, BlockStateRandomizer legRandomizer) {
            this.mainRandomizer = mainRandomizer;
            this.floorRandomizer = floorRandomizer;
            this.brickRandomizer = brickRandomizer;
            this.legRandomizer = legRandomizer;
        }
    }
}

