/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.json.BlockStateAdapter;
import java.io.IOException;
import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateRandomizerAdapter
extends TypeAdapter<BlockStateRandomizer> {
    public BlockStateRandomizer read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        BlockStateRandomizer randomizer = new BlockStateRandomizer();
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "entries": {
                    BlockState blockState;
                    reader.beginObject();
                    while (reader.hasNext()) {
                        blockState = BlockStateAdapter.resolveBlockState(reader.nextName());
                        double probability = reader.nextDouble();
                        randomizer.addBlock(blockState, (float)probability);
                    }
                    reader.endObject();
                    break;
                }
                case "defaultBlock": {
                    BlockState blockState = BlockStateAdapter.resolveBlockState(reader.nextString());
                    randomizer.setDefaultBlockState(blockState);
                }
            }
        }
        reader.endObject();
        return randomizer;
    }

    public void write(JsonWriter writer, BlockStateRandomizer randomizer) throws IOException {
        if (randomizer == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("entries").beginObject();
        for (Map.Entry<BlockState, Float> entry : randomizer.getEntriesAsMap().entrySet()) {
            writer.name(this.trimmedBlockName(String.valueOf(entry.getKey()))).value((Number)entry.getValue());
        }
        writer.endObject();
        String defaultBlockString = String.valueOf(randomizer.getDefaultBlockState());
        defaultBlockString = this.trimmedBlockName(defaultBlockString);
        writer.name("defaultBlock").value(defaultBlockString);
        writer.endObject();
    }

    private String trimmedBlockName(String blockString) {
        if (blockString.startsWith("Block")) {
            blockString = blockString.substring(5);
        }
        blockString = blockString.replace("{", "");
        blockString = blockString.replace("}", "");
        return blockString;
    }
}

