/*
 * Decompiled with CFR 0.152.
 */
package fuzs.ytones.world.level.block;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.init.v3.tags.TypedTagFactory;
import fuzs.ytones.Ytones;
import fuzs.ytones.tags.DyeItemTags;
import fuzs.ytones.world.level.block.ToneBlock;
import fuzs.ytones.world.level.block.ToneGlassBlock;
import fuzs.ytones.world.level.block.ToneType;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.commons.lang3.StringUtils;

public enum Tone implements StringRepresentable
{
    AGON(new ItemLike[]{Items.WHITE_CONCRETE, Items.ORANGE_CONCRETE, Items.MAGENTA_CONCRETE, Items.LIGHT_BLUE_CONCRETE, Items.YELLOW_CONCRETE, Items.LIME_CONCRETE, Items.PINK_CONCRETE, Items.GRAY_CONCRETE, Items.LIGHT_GRAY_CONCRETE, Items.CYAN_CONCRETE, Items.PURPLE_CONCRETE, Items.BLUE_CONCRETE, Items.BROWN_CONCRETE, Items.GREEN_CONCRETE, Items.RED_CONCRETE, Items.BLACK_CONCRETE}),
    AZUR(DyeItemTags.BLUE_DYES),
    BITT(new ItemLike[]{Items.COAL}),
    CRAY((TagKey<Item>)ItemTags.TERRACOTTA),
    FORT(new ItemLike[]{Blocks.TUFF}),
    GLAXX(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), (tone, type) -> new ToneGlassBlock((Tone)((Object)tone), (ToneType)((Object)type), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS))),
    ISZM(new ItemLike[]{Blocks.DEEPSLATE}),
    JELT(DyeItemTags.ORANGE_DYES),
    KORP(new ItemLike[]{Blocks.GRAVEL}),
    KRYP(new ItemLike[]{Blocks.DIRT}),
    LAIR(new ItemLike[]{Blocks.GRANITE}),
    LAVE(DyeItemTags.LIGHT_BLUE_DYES),
    MINT(DyeItemTags.LIME_DYES),
    MYST(new ItemLike[]{Blocks.SNOW}),
    REDS(DyeItemTags.RED_DYES),
    REED(new ItemLike[]{Blocks.SUGAR_CANE}),
    ROEN(new ItemLike[]{Blocks.SAND}),
    SOLS(DyeItemTags.YELLOW_DYES),
    SYNC(DyeItemTags.GREEN_DYES),
    TANK(DyeItemTags.GRAY_DYES),
    VECT(DyeItemTags.BLACK_DYES),
    VENA(new ItemLike[]{Blocks.ANDESITE}),
    ZANE(new ItemLike[]{Blocks.CALCITE}),
    ZECH(new ItemLike[]{Items.CHARCOAL}),
    ZEST(new ItemLike[]{Blocks.MUD}),
    ZETA(new ItemLike[]{Blocks.BASALT}),
    ZION(new ItemLike[]{Blocks.SMOOTH_BASALT}),
    ZKUL(new ItemLike[]{Items.BONE}),
    ZOEA(new ItemLike[]{Blocks.DIORITE}),
    ZOME(new ItemLike[]{Blocks.COBBLESTONE}),
    ZONE(new ItemLike[]{Blocks.COBBLED_DEEPSLATE}),
    ZORG(new ItemLike[]{Blocks.CLAY}),
    ZTYL(DyeItemTags.LIGHT_GRAY_DYES),
    ZYTH(new ItemLike[]{Blocks.BLACKSTONE});

    public static final StringRepresentable.StringRepresentableCodec<Tone> CODEC;
    public final Ingredient ingredient;
    public final Function<ToneType, Block> factory;
    private final Map<ToneType, Block> blocks = Maps.newEnumMap(ToneType.class);

    private Tone(ItemLike ... item) {
        this(Ingredient.of((ItemLike[])item));
    }

    private Tone(TagKey<Item> tagKey) {
        this(Ingredient.of(tagKey));
    }

    private Tone(Ingredient ingredient) {
        this(ingredient, (Tone tone, ToneType type) -> new ToneBlock((Tone)((Object)tone), (ToneType)((Object)type), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    }

    private Tone(Ingredient ingredient, BiFunction<Tone, ToneType, Block> factory) {
        this.ingredient = ingredient;
        this.factory = type -> (Block)factory.apply(this, (ToneType)((Object)type));
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static void forEach(BiConsumer<Tone, ToneType> consumer) {
        for (Tone tone : Tone.values()) {
            for (ToneType type : ToneType.values()) {
                consumer.accept(tone, type);
            }
        }
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String id(ToneType type) {
        return this.id() + "_" + type.id();
    }

    public String text() {
        return StringUtils.capitalize((String)this.name().toLowerCase(Locale.ROOT));
    }

    public String text(ToneType type) {
        return this.text() + " " + type.text();
    }

    public Block block(ToneType type) {
        return this.blocks.computeIfAbsent(type, $ -> (Block)BuiltInRegistries.BLOCK.get(Ytones.id(this.id(type))));
    }

    public TagKey<Block> getBlockTagKey() {
        return TypedTagFactory.BLOCK.make("ytones", this.id());
    }

    public TagKey<Item> getItemTagKey() {
        return TypedTagFactory.ITEM.make("ytones", this.id());
    }

    static {
        CODEC = StringRepresentable.fromEnum(Tone::values);
    }
}

