/*
 * Decompiled with CFR 0.152.
 */
package fuzs.ytones.neoforge.data.client;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.client.AbstractModelProvider;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import fuzs.ytones.init.ModRegistry;
import fuzs.ytones.world.level.block.FlatLampBlock;
import fuzs.ytones.world.level.block.Tone;
import fuzs.ytones.world.level.block.ToneType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.apache.commons.lang3.ArrayUtils;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(NeoForgeDataProviderContext context) {
        super(context);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithItem((Block)ModRegistry.YTONE_BLOCK.value(), this.cubeAll((Block)ModRegistry.YTONE_BLOCK.value()));
        Tone.forEach((tone, toneType) -> {
            Block block = tone.block((ToneType)((Object)toneType));
            ResourceLocation texture = this.blockTexture(block);
            texture = ResourceLocationHelper.fromNamespaceAndPath((String)texture.getNamespace(), (String)texture.getPath().replaceAll(toneType.id() + "$", String.valueOf(toneType.ordinal())));
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.name(block), texture);
            this.simpleBlockWithItem(block, (ModelFile)model);
        });
        this.getVariantBuilder((Block)ModRegistry.FLAT_LAMP_BLOCK.value()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)FlatLampBlock.FACING);
            boolean lit = (Boolean)state.getValue((Property)FlatLampBlock.LIT);
            ResourceLocation path = this.blockTexture((Block)ModRegistry.FLAT_LAMP_BLOCK.value());
            ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(ResourceLocationHelper.fromNamespaceAndPath((String)path.getNamespace(), (String)(path.getPath() + (lit ? "_on" : "_off"))));
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(facing == Direction.DOWN ? 180 : (facing.getAxis().isHorizontal() ? 90 : 0)).rotationY(facing.getAxis().isVertical() ? 0 : ((int)facing.toYRot() + 180) % 360).build();
        }, new Property[]{FlatLampBlock.WATERLOGGED});
        ResourceLocation resourceLocation = this.key((Block)ModRegistry.FLAT_LAMP_BLOCK.value());
        resourceLocation = ResourceLocationHelper.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)(resourceLocation.getPath() + "_on"));
        this.itemModels().withExistingParent(this.name((Block)ModRegistry.FLAT_LAMP_BLOCK.value()), this.extendKey(resourceLocation, "block"));
    }

    public ResourceLocation extendKey(ResourceLocation resourceLocation, String ... extensions) {
        extensions = (String[])ArrayUtils.add((Object[])extensions, (Object)resourceLocation.getPath());
        return ResourceLocationHelper.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)String.join((CharSequence)"/", extensions));
    }
}

