/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen;

import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.world.gen.WerewolvesBiomeFeatures;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class WerewolfForestBiome {
    public static Biome createWerewolfForestBiome(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        return WerewolfForestBiome.addAttributes(WerewolfForestBiome.createGenerationBuilder(featureGetter, carverGetter), WerewolfForestBiome.createMobSpawnBuilder(), WerewolfForestBiome.createEffectBuilder()).build();
    }

    public static Biome.BiomeBuilder addAttributes(BiomeGenerationSettings.Builder featureBuilder, MobSpawnSettings.Builder spawnBuilder, BiomeSpecialEffects.Builder ambienceBuilder) {
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.3f).downfall(0.0f).specialEffects(ambienceBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(featureBuilder.build());
    }

    public static MobSpawnSettings.Builder createMobSpawnBuilder() {
        return new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ALPHA_WEREWOLF.get(), 10, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WEREWOLF_BEAST.get(), 70, 1, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), 70, 1, 2));
    }

    public static BiomeSpecialEffects.Builder createEffectBuilder() {
        return new BiomeSpecialEffects.Builder().waterColor(0x444444).waterFogColor(0x444444).skyColor(0x444444).fogColor(0x444444).foliageColorOverride(3627832).grassColorOverride(0x444444).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS);
    }

    public static BiomeGenerationSettings.Builder createGenerationBuilder(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)builder);
        WerewolvesBiomeFeatures.addForestStone(builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)builder);
        WerewolvesBiomeFeatures.addWerewolfBiomeTrees(builder);
        WerewolvesBiomeFeatures.addWolfBerries(builder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)builder);
        return builder;
    }
}

