/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.inventory.recipes;

import com.mojang.datafixers.util.Either;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class TagNBTBrewingRecipe
implements IBrewingRecipe {
    private final Ingredient input;
    private final Either<TagKey<Item>, Ingredient> ingredient;
    private final ItemStack output;

    public TagNBTBrewingRecipe(Ingredient input, TagKey<Item> ingredient, ItemStack output) {
        this.input = input;
        this.ingredient = Either.left(ingredient);
        this.output = output;
    }

    public TagNBTBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        this.input = input;
        this.ingredient = Either.right((Object)ingredient);
        this.output = output;
    }

    public boolean isInput(@Nonnull ItemStack input) {
        return Helper.matchesItem(this.input, input);
    }

    public boolean isIngredient(@Nonnull ItemStack ingredient) {
        return (Boolean)this.ingredient.map(arg_0 -> ((ItemStack)ingredient).is(arg_0), i -> i.test(ingredient));
    }

    @Nonnull
    public ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.output.copy() : ItemStack.EMPTY;
    }

    public ItemStack[] getIngredient() {
        return (ItemStack[])this.ingredient.map(i -> (ItemStack[])BuiltInRegistries.ITEM.getTag(i).stream().flatMap(HolderSet.ListBacked::stream).map(ItemStack::new).toArray(ItemStack[]::new), Ingredient::getItems);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

