/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.ISyncableSaveData;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.WerewolvesAttachments;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.IWerewolfArmor;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttachments;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.effects.WolfsbaneEffect;
import de.teamlapen.werewolves.effects.inst.WerewolfNightVisionEffectInstance;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfInventory;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.mixin.entity.PlayerAccessor;
import de.teamlapen.werewolves.util.DamageHandler;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.world.LevelWolfsbane;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WerewolfPlayer
extends FactionBasePlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CLAWS = WResourceLocation.mod("claws");
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);
    private final Customization customization = new Customization();
    private final WerewolfInventory inventory = new WerewolfInventory(this);
    private int sleepTimer;
    private int wolfsbaneCache = -1;

    public static WerewolfPlayer get(@Nonnull Player playerEntity) {
        return (WerewolfPlayer)playerEntity.getData(ModAttachments.WEREWOLF_PLAYER);
    }

    @Deprecated
    public static Optional<WerewolfPlayer> getOpt(@Nonnull Player playerEntity) {
        return Optional.of(WerewolfPlayer.get(playerEntity));
    }

    @Deprecated(forRemoval=true)
    public static Optional<WerewolfPlayer> getOptSave(Player player) {
        return WerewolfPlayer.getOpt(player);
    }

    public static Optional<WerewolfPlayer> getOptEx(@Nullable Entity entity) {
        if (!(entity instanceof Player) || !Helper.isWerewolf((Player)entity)) {
            return Optional.empty();
        }
        return WerewolfPlayer.getOpt((Player)entity);
    }

    public WerewolfPlayer(@Nonnull Player player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.level().isClientSide) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.putString("form", this.form.getName())), true);
        }
    }

    public WerewolfInventory getInventory() {
        return this.inventory;
    }

    public void switchForm(WerewolfForm form) {
        if (this.form == form) {
            return;
        }
        this.form = form;
        this.player.refreshDimensions();
        if (!this.form.isHumanLike()) {
            ((PlayerAccessor)this.player).invoke_removeEntitiesOnShoulder();
        }
        if (!this.player.level().isClientSide) {
            this.inventory.swapArmorItems(form);
        }
        this.checkToolDamage(this.player.getMainHandItem(), this.player.getMainHandItem(), true);
    }

    @Override
    public boolean canWearArmor(ItemStack stack) {
        return this.canWearArmor(this.form, stack);
    }

    public boolean canWearArmor(List<ItemStack> stacks) {
        return stacks.stream().allMatch(this::canWearArmor);
    }

    public boolean canWearArmor(WerewolfForm form, List<ItemStack> stack) {
        return stack.stream().allMatch(s -> this.canWearArmor(form, (ItemStack)s));
    }

    public boolean canWearArmor(WerewolfForm form, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof IWerewolfArmor) {
            IWerewolfArmor armor = (IWerewolfArmor)item;
            return armor.canWear(this, form);
        }
        return form.isHumanLike() && (!form.isTransformed() || this.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get()));
    }

    public void onChangedDimension(ResourceKey<Level> registryKey, ResourceKey<Level> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.getCommandSenderWorld().getProfiler().push("werewolves_werewolfplayer");
        super.onUpdate();
        if (this.getLevel() > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    syncPacket.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT((HolderLookup.Provider)this.player.registryAccess()));
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncToAll = true;
                    syncPacket.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT((HolderLookup.Provider)this.player.registryAccess()));
                }
                if (this.player.level().getGameTime() % 10L == 0L) {
                    if (this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                        this.specialAttributes.transformationTime = Mth.clamp((double)(this.specialAttributes.transformationTime - this.player.getAttribute(ModAttributes.TIME_REGAIN).getValue()), (double)0.0, (double)1.0);
                        syncPacket.putDouble("transformationTime", this.specialAttributes.transformationTime);
                    }
                    if (this.player.level().getGameTime() % 20L == 0L) {
                        if (Helper.isFullMoon(this.getRepresentingPlayer().getCommandSenderWorld()) && !FormHelper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.FREE_WILL.get())) {
                            Optional<WerewolfFormAction> action = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                            action.ifPresent(a -> this.actionHandler.toggleAction(a, (IAction.ActivationContext)new ActionHandler.ActivationContext()));
                        }
                        if (this.player.isInWater() && this.player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.WATER_LOVER.get())) {
                            this.player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 50, 0, true, true));
                        }
                    }
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.HEALTH_REG.get())) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                MobEffectInstance effect = this.player.getEffect(MobEffects.NIGHT_VISION);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
                    if (effect == null || !VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)((EffectInstanceWithSource)effect).getSource())) {
                        if (effect != null) {
                            this.player.removeEffectNoUpdate(effect.getEffect());
                        }
                        this.player.addEffect((MobEffectInstance)new WerewolfNightVisionEffectInstance(effect));
                    }
                } else if (effect != null && VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)((EffectInstanceWithSource)effect).getSource())) {
                    this.player.removeEffect(effect.getEffect());
                    effect = ((EffectInstanceWithSource)effect).getHiddenEffect();
                    if (effect != null) {
                        this.player.addEffect(effect);
                    }
                }
                if (this.player.tickCount % 40 == 0 && this.isAffectedByWolfsbane((LevelAccessor)this.player.level(), true)) {
                    this.player.addEffect(WolfsbaneEffect.createWolfsbaneEffect((LivingEntity)this.player, 50, this.wolfsbaneCache));
                }
            } else {
                this.actionHandler.updateActions();
                if (this.player.level().getGameTime() % 10L == 0L && this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                    this.specialAttributes.transformationTime = Mth.clamp((double)(this.specialAttributes.transformationTime - (double)((float)this.player.getAttribute(ModAttributes.TIME_REGAIN).getValue())), (double)0.0, (double)1.0);
                }
                MobEffectInstance effect = this.player.getEffect(MobEffects.NIGHT_VISION);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision && !(effect instanceof WerewolfNightVisionEffectInstance)) {
                    this.player.removeEffectNoUpdate(MobEffects.NIGHT_VISION);
                    this.player.addEffect((MobEffectInstance)new WerewolfNightVisionEffectInstance());
                }
            }
            this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        } else if (!this.isRemote() && this.player.isSleeping() && this.player.hasEffect(ModEffects.LUPUS_SANGUINEM)) {
            if (this.sleepTimer++ >= 200) {
                this.player.getEffect(ModEffects.LUPUS_SANGUINEM).tick((LivingEntity)this.player, () -> {});
                this.player.removeEffect(ModEffects.LUPUS_SANGUINEM);
                this.player.stopSleeping();
            }
        } else {
            this.sleepTimer = 0;
        }
        this.player.getCommandSenderWorld().getProfiler().pop();
    }

    public void onUpdatePlayer(PlayerTickEvent playerTickEvent) {
    }

    private void tickFoodStats() {
        FoodData stats = this.player.getFoodData();
        ((FoodStatsAccessor)stats).setTickTimer(((FoodStatsAccessor)stats).getTickTimer() + 1);
    }

    public boolean setGlowingEyes(WerewolfForm form, boolean on) {
        if (on != this.customization.glowingEyes.getOrDefault(form, false)) {
            this.customization.glowingEyes.put(form, on);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.put(this.customization.nbtKey(), (Tag)this.customization.serializeGlowingEyesNBT());
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setEyeType(WerewolfForm form, int type) {
        if (type != this.customization.eyeType.getOrDefault(form, -1)) {
            this.customization.eyeType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.put(this.customization.nbtKey(), (Tag)this.customization.serializeEyeNBT((HolderLookup.Provider)this.player.registryAccess()));
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setSkinType(WerewolfForm form, int type) {
        if (type != this.customization.skinType.getOrDefault(form, -1)) {
            this.customization.skinType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.put(this.customization.nbtKey(), (Tag)this.customization.serializeSkinNBT((HolderLookup.Provider)this.player.registryAccess()));
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(WerewolfForm form, int[] data) {
        this.setEyeType(form, data[0]);
        this.setSkinType(form, data[1]);
        this.setGlowingEyes(form, data[2] == 1);
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            this.player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 1));
            this.actionHandler.extendActionTimer((ILastingAction)ModActions.RAGE.get(), ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.rage_fury_timer_extend.get()).intValue());
        }
        this.levelHandler.increaseProgress((int)((double)victim.getMaxHealth() * 0.2));
        this.syncLevelHandler();
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void syncLevelHandler() {
        CompoundTag sync = new CompoundTag();
        sync.put(this.levelHandler.nbtKey(), (Tag)this.levelHandler.serializeUpdateNBT((HolderLookup.Provider)this.player.registryAccess()));
        this.sync(sync, false);
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.distanceTo((Entity)this.player) <= this.player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() + 1.0 && (!(entity instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.isSpectator() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0 && (!(this.player instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.level().getEntity(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if (!this.canBite()) {
            return false;
        }
        if (!this.canBiteEntity(entity)) {
            return false;
        }
        double damage = this.player.getAttribute(ModAttributes.BITE_DAMAGE).getValue();
        boolean flag = DamageHandler.hurtModded((Entity)entity, sources -> sources.bite((LivingEntity)this.player), (float)damage);
        if (flag) {
            this.getRepresentingPlayer().playSound((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), 1.0f, 1.0f);
            this.getRepresentingPlayer().playNotifySound((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = (Integer)WerewolvesConfig.BALANCE.PLAYER.bite_cooldown.get();
            if (!this.getForm().isHumanLike()) {
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.STUN_BITE.get())) {
                    int duration = (Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get();
                    if (this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.STUN_BITE.get())) {
                        duration += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.stun_bite_duration_extend.get()).intValue();
                    }
                    entity.addEffect(new MobEffectInstance(ModEffects.STUN, duration));
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.BLEEDING_BITE.get())) {
                    entity.addEffect(new MobEffectInstance(ModEffects.BLEEDING, ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue(), this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.BLEEDING_BITE.get()) ? 3 : 0));
                }
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.putInt("biteTicks", this.specialAttributes.biteTicks)), false);
            if (!(entity instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.INFECT_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
                LupusSanguinemEffect.infectRandomByPlayer(entity);
            }
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (!Helper.isNoLiving(entity)) {
            return;
        }
        if (!entity.isAlive()) {
            this.player.getFoodData().eat(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        super.onLevelChanged(newLevel, oldLevel);
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((Player)this.player, (ObjectiveCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((Player)this.player, (Holder)Attributes.MOVEMENT_SPEED, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Holder)Attributes.ARMOR_TOUGHNESS, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Holder)Attributes.ATTACK_DAMAGE, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (boolean)false);
            if (newLevel <= 0) {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
        }
    }

    public boolean isAffectedByWolfsbane(LevelAccessor accessor, boolean forceRefresh) {
        if (forceRefresh) {
            int n;
            if (accessor instanceof Level) {
                Level level = (Level)accessor;
                n = LevelWolfsbane.getOpt(level).map(x -> x.isEffectedByWolfsbane(this.getRepresentingPlayer().blockPosition())).orElse(-1);
            } else {
                n = -1;
            }
            this.wolfsbaneCache = n;
        }
        return this.wolfsbaneCache > -1;
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.getFoodData().eat(1, 1.0f);
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    public Optional<Tier> getDigDropTier() {
        return Optional.ofNullable(this.specialAttributes.diggerTier);
    }

    public float getDigSpeed() {
        return this.specialAttributes.diggingSpeed;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate((IFaction)this.getFaction(), ignoreDisguise);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    @Nullable
    public WerewolfFormAction getLastFormAction() {
        return this.lastFormAction;
    }

    @NotNull
    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.put(this.inventory.nbtKey(), (Tag)this.inventory.serializeNBT(provider));
        compound.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeNBT(provider));
        compound.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeNBT(provider));
        compound.put(this.levelHandler.nbtKey(), (Tag)this.levelHandler.serializeNBT(provider));
        compound.put(this.customization.nbtKey(), (Tag)this.customization.serializeNBT(provider));
        compound.putString("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.putString("lastFormAction", RegUtil.id((IAction)this.lastFormAction).toString());
        }
        compound.putInt("biteTicks", this.specialAttributes.biteTicks);
        compound.putDouble("transformationTime", this.specialAttributes.transformationTime);
        return compound;
    }

    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeUpdateNBT(provider);
        nbt.put(this.inventory.nbtKey(), (Tag)this.inventory.serializeUpdateNBT(provider));
        nbt.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT(provider));
        nbt.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT(provider));
        nbt.put(this.levelHandler.nbtKey(), (Tag)this.levelHandler.serializeUpdateNBT(provider));
        nbt.put(this.customization.nbtKey(), (Tag)this.customization.serializeUpdateNBT(provider));
        nbt.putString("form", this.form.getName());
        nbt.putInt("biteTicks", this.specialAttributes.biteTicks);
        nbt.putDouble("transformationTime", this.specialAttributes.transformationTime);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.inventory.deserializeNBT(provider, nbt.getCompound(this.inventory.nbtKey()));
        this.skillHandler.deserializeNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
        this.actionHandler.deserializeNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.levelHandler.deserializeNBT(provider, nbt.getCompound(this.levelHandler.nbtKey()));
        this.customization.deserializeNBT(provider, nbt.getCompound(this.customization.nbtKey()));
        if (NBTHelper.containsString(nbt, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)RegUtil.getAction((ResourceLocation)ResourceLocation.parse((String)nbt.getString("lastFormAction")));
        }
        this.specialAttributes.biteTicks = nbt.getInt("biteTicks");
        if (nbt.contains("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.getFloat("transformationTime");
        }
    }

    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeUpdateNBT(provider, nbt);
        this.inventory.deserializeUpdateNBT(provider, nbt.getCompound(this.inventory.nbtKey()));
        this.skillHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
        this.actionHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.levelHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.levelHandler.nbtKey()));
        this.customization.deserializeUpdateNBT(provider, nbt.getCompound(this.customization.nbtKey()));
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(this.form);
        }
        if (nbt.contains("biteTicks")) {
            this.specialAttributes.biteTicks = nbt.getInt("biteTicks");
        }
        if (nbt.contains("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.getFloat("transformationTime");
        }
    }

    private void applyEntityAttributes() {
        try {
            this.player.getAttribute(ModAttributes.BITE_DAMAGE);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public void checkToolDamage(@NotNull ItemStack from, @NotNull ItemStack itemInHand, boolean forceCalculation) {
        AttributeInstance attribute = this.player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (this.getLevel() > 0 && this.form.isTransformed() && itemInHand.isEmpty()) {
            if (!from.isEmpty() || forceCalculation) {
                float damage = ((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_claw_damage.get()).floatValue();
                if (this.specialAttributes.diggerTier != null) {
                    damage += (1.0f + this.specialAttributes.diggerTier.getAttackDamageBonus()) / 2.0f;
                }
                attribute.removeModifier(CLAWS);
                attribute.addTransientModifier(new AttributeModifier(CLAWS, (double)damage, AttributeModifier.Operation.ADD_VALUE));
            }
        } else {
            attribute.removeModifier(CLAWS);
        }
    }

    public void checkWerewolfFormModifier() {
        WerewolfFormAction.getAllAction().stream().filter(action -> this.getActionHandler().isActionActive((ILastingAction)action)).findAny().ifPresent(action -> action.checkDayNightModifier(this));
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.customization.eyeType.getOrDefault(form, 0);
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.customization.skinType.getOrDefault(form, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.customization.glowingEyes.getOrDefault(form, false);
    }

    public void dropEquipment() {
        this.inventory.dropEquipment();
    }

    @Override
    public void updateMinionAttributes(boolean increasedStats) {
        MinionWorldData.getData((Level)this.player.level()).flatMap(a -> FactionPlayerHandler.getOpt((Player)this.player).map(arg_0 -> ((MinionWorldData)a).getOrCreateController(arg_0))).ifPresent(controller -> controller.contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((WerewolfMinionEntity.WerewolfMinionData)((Object)((Object)((Object)b)))).setIncreasedStats(increasedStats));
            HelperLib.sync((Entity)minion);
        }));
    }

    public ResourceLocation getAttachedKey() {
        return WerewolvesAttachments.Keys.WEREWOLF_PLAYER;
    }

    public String nbtKey() {
        return this.getAttachedKey().getPath();
    }

    public static class Customization
    implements ISyncableSaveData {
        private static final String KEY_CUSTOMIZATION = "customization";
        private final Map<WerewolfForm, Integer> eyeType = new HashMap<WerewolfForm, Integer>();
        private final Map<WerewolfForm, Integer> skinType = new HashMap<WerewolfForm, Integer>();
        private final Map<WerewolfForm, Boolean> glowingEyes = new HashMap<WerewolfForm, Boolean>();

        @NotNull
        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            CompoundTag eye = new CompoundTag();
            this.eyeType.forEach((key, value) -> eye.putInt(key.getName(), value.intValue()));
            tag.put("eyeTypes", (Tag)eye);
            CompoundTag skin = new CompoundTag();
            this.skinType.forEach((key, value) -> skin.putInt(key.getName(), value.intValue()));
            tag.put("skinTypes", (Tag)skin);
            CompoundTag glowingEye = new CompoundTag();
            this.glowingEyes.forEach((key, value) -> glowingEye.putBoolean(key.getName(), value.booleanValue()));
            tag.put("glowingEyes", (Tag)glowingEye);
            return tag;
        }

        @NotNull
        public CompoundTag serializeEyeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            CompoundTag eye = new CompoundTag();
            this.eyeType.forEach((key, value) -> eye.putInt(key.getName(), value.intValue()));
            tag.put("eyeTypes", (Tag)eye);
            return tag;
        }

        @NotNull
        public CompoundTag serializeSkinNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            CompoundTag skin = new CompoundTag();
            this.skinType.forEach((key, value) -> skin.putInt(key.getName(), value.intValue()));
            tag.put("skinTypes", (Tag)skin);
            return tag;
        }

        @NotNull
        public CompoundTag serializeGlowingEyesNBT() {
            CompoundTag tag = new CompoundTag();
            CompoundTag glowingEye = new CompoundTag();
            this.glowingEyes.forEach((key, value) -> glowingEye.putBoolean(key.getName(), value.booleanValue()));
            tag.put("glowingEyes", (Tag)glowingEye);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, @NotNull CompoundTag compoundTag) {
            CompoundTag eye = compoundTag.getCompound("eyeTypes");
            eye.getAllKeys().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.getInt(string)));
            CompoundTag skin = compoundTag.getCompound("skinTypes");
            skin.getAllKeys().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.getInt(string)));
            CompoundTag glowingEyes = compoundTag.getCompound("glowingEyes");
            glowingEyes.getAllKeys().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.getBoolean(string)));
        }

        public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag compoundTag) {
            if (compoundTag.contains("eyeTypes")) {
                CompoundTag eye = compoundTag.getCompound("eyeTypes");
                eye.getAllKeys().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.getInt(string)));
            }
            if (compoundTag.contains("skinTypes")) {
                CompoundTag skin = compoundTag.getCompound("skinTypes");
                skin.getAllKeys().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.getInt(string)));
            }
            if (compoundTag.contains("glowingEyes")) {
                CompoundTag glowingEyes = compoundTag.getCompound("glowingEyes");
                glowingEyes.getAllKeys().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.getBoolean(string)));
            }
        }

        @NotNull
        public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
            return this.serializeNBT(provider);
        }

        public String nbtKey() {
            return KEY_CUSTOMIZATION;
        }
    }

    public static class Factory
    implements Function<IAttachmentHolder, WerewolfPlayer> {
        @Override
        public WerewolfPlayer apply(IAttachmentHolder holder) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new WerewolfPlayer(player);
            }
            throw new IllegalArgumentException("Cannot create hunter player attachment for holder " + String.valueOf(holder.getClass()) + ". Expected Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, WerewolfPlayer> {
        @NotNull
        public WerewolfPlayer read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                WerewolfPlayer werewolf = new WerewolfPlayer(player);
                werewolf.deserializeNBT(provider, tag);
                return werewolf;
            }
            throw new IllegalArgumentException("Expected Player, got " + holder.getClass().getSimpleName());
        }

        public CompoundTag write(WerewolfPlayer attachment, HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

