/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.Maps;
import de.teamlapen.werewolves.api.WResourceLocation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class ModLootTables {
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES = new HashSet<ResourceKey<LootTable>>();
    private static final Map<ResourceKey<LootTable>, ResourceKey<LootTable>> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceKey<LootTable> HUNTER_LIVER = ModLootTables.register(WResourceLocation.mod("hunter_liver"));
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT);
    public static final ResourceKey<LootTable> JUNGLE_TEMPLE = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE);
    public static final ResourceKey<LootTable> STRONGHOLD_CORRIDOR = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR);
    public static final ResourceKey<LootTable> DESERT_PYRAMID = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID);
    public static final ResourceKey<LootTable> STRONGHOLD_LIBRARY = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_LIBRARY);
    public static final ResourceKey<LootTable> NETHER_BRIDGE = ModLootTables.registerInject((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
    public static final ResourceKey<LootTable> VILLAGER = ModLootTables.registerInject(EntityType.VILLAGER);
    public static final ResourceKey<LootTable> SKELETON = ModLootTables.registerInject(EntityType.SKELETON);

    static ResourceKey<LootTable> registerInject(EntityType<?> type) {
        ResourceKey loc = type.getDefaultLootTable();
        ResourceKey<LootTable> newLoc = ModLootTables.register(WResourceLocation.mod(loc.location().withPrefix("inject/entity/").getPath()));
        INJECTION_TABLES.put((ResourceKey<LootTable>)loc, newLoc);
        return newLoc;
    }

    @NotNull
    static ResourceKey<LootTable> registerInject(ResourceKey<LootTable> originalTable) {
        ResourceKey<LootTable> key = ModLootTables.register(originalTable.location().withPrefix("inject/"));
        INJECTION_TABLES.put(originalTable, key);
        return key;
    }

    @NotNull
    static ResourceKey<LootTable> register(@NotNull ResourceLocation resourceLocation) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation);
        LOOT_TABLES.add((ResourceKey<LootTable>)key);
        return key;
    }

    @NotNull
    public static Set<ResourceKey<LootTable>> getLootTables() {
        return Collections.unmodifiableSet(LOOT_TABLES);
    }

    @NotNull
    public static Map<ResourceKey<LootTable>, ResourceKey<LootTable>> getInjectTables() {
        return Collections.unmodifiableMap(INJECTION_TABLES);
    }
}

