/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WerewolfEarsModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final String HEAD = "head";
    public static final String CLAWS_LEFT = "clawsLeft";
    public static final String CLAWS_RIGHT = "clawsRight";
    public static final String EAR_RIGHT = "earRight";
    public static final String EAR_LEFT = "earLeft";
    public final ModelPart clawsLeft;
    public final ModelPart clawsRight;

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.getChild(HEAD);
        PartDefinition earRight = head.addOrReplaceChild(EAR_RIGHT, CubeListBuilder.create().texOffs(16, 0).addBox(-4.9f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.rotation((float)-0.4886922f, (float)-0.2617994f, (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild(EAR_LEFT, CubeListBuilder.create().texOffs(16, 0).addBox(3.9f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.rotation((float)-0.4886922f, (float)0.2617994f, (float)0.0f));
        return mesh;
    }

    public static LayerDefinition createDefaultLayer() {
        MeshDefinition mesh = WerewolfEarsModel.createMesh();
        PartDefinition root = mesh.getRoot();
        PartDefinition clawsRight = root.getChild("right_arm").addOrReplaceChild(CLAWS_RIGHT, CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.ZERO);
        PartDefinition clawsLeft = root.getChild("left_arm").addOrReplaceChild(CLAWS_LEFT, CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static LayerDefinition createSlimLayer() {
        MeshDefinition mesh = WerewolfEarsModel.createMesh();
        PartDefinition root = mesh.getRoot();
        PartDefinition clawsRight = root.getChild("right_arm").addOrReplaceChild(CLAWS_RIGHT, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 10.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        PartDefinition clawsLeft = root.getChild("left_arm").addOrReplaceChild(CLAWS_LEFT, CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, 10.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public WerewolfEarsModel(ModelPart part) {
        super(part);
        this.head.skipDraw = true;
        this.rightArm.skipDraw = true;
        this.leftArm.skipDraw = true;
        this.clawsRight = this.rightArm.getChild(CLAWS_RIGHT);
        this.clawsLeft = this.leftArm.getChild(CLAWS_LEFT);
    }

    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.rightArm, (Object)this.leftArm);
    }

    @Nonnull
    public static List<ResourceLocation> getHumanTextures() {
        List<ResourceLocation> locs = Minecraft.getInstance().getResourceManager().listResources("textures/entity/werewolf/human", s -> s.getPath().endsWith(".png")).keySet().stream().filter(r -> "werewolves".equals(r.getNamespace())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.HUMAN.getSkinTypes()) {
            for (int i = 0; i < WerewolfForm.HUMAN.getSkinTypes(); ++i) {
                ResourceLocation s2 = WResourceLocation.mod("textures/entity/werewolf/human/werewolf_ear_claws_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }
}

