/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.StakeItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class StakeCondition
implements LootItemCondition {
    public static final MapCodec<StakeCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootContext.EntityTarget.CODEC.fieldOf("target").forGetter(l -> l.target)).apply((Applicative)inst, StakeCondition::new));
    private final LootContext.EntityTarget target;

    @NotNull
    public static LootItemCondition.Builder builder(LootContext.EntityTarget target) {
        return () -> new StakeCondition(target);
    }

    public StakeCondition(LootContext.EntityTarget targetIn) {
        this.target = targetIn;
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLoot.WITH_STAKE.get();
    }

    public boolean test(@NotNull LootContext context) {
        Entity player = (Entity)context.getParamOrNull(this.target.getParam());
        if (player instanceof Player) {
            ItemStack active = ((Player)player).getMainHandItem();
            return !active.isEmpty() && active.getItem() instanceof StakeItem;
        }
        return false;
    }
}

