/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.core.ModLoot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class AdjustableLevelCondition
implements LootItemCondition {
    public static final MapCodec<AdjustableLevelCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("level").forGetter(l -> l.levelTest), (App)LootContext.EntityTarget.CODEC.fieldOf("target").forGetter(l -> l.target)).apply((Applicative)inst, AdjustableLevelCondition::new));
    private final int levelTest;
    private final LootContext.EntityTarget target;

    @NotNull
    public static LootItemCondition.Builder builder(int level, LootContext.EntityTarget target) {
        return () -> new AdjustableLevelCondition(level, target);
    }

    public AdjustableLevelCondition(int level, LootContext.EntityTarget targetIn) {
        this.levelTest = level;
        this.target = targetIn;
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLoot.ADJUSTABLE_LEVEL.get();
    }

    public boolean test(@NotNull LootContext lootContext) {
        Entity e = (Entity)lootContext.getParamOrNull(this.target.getParam());
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getEntityLevel();
            if (this.levelTest != -1) {
                return this.levelTest == l;
            }
        }
        return false;
    }
}

