/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.templatesystem;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.mixin.accessor.ProcessorRuleAccessor;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RandomBlockStateRule
extends ProcessorRule {
    public static final Codec<Pair<BlockState, RuleBlockEntityModifier>> PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(entry -> (BlockState)entry.getLeft()), (App)RuleBlockEntityModifier.CODEC.optionalFieldOf("output_nbt", (Object)DEFAULT_BLOCK_ENTITY_MODIFIER).forGetter(entry -> (RuleBlockEntityModifier)entry.getValue())).apply((Applicative)instance, ImmutablePair::new));
    public static final Codec<RandomBlockStateRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.CODEC.fieldOf("input_predicate").forGetter(getter -> ((ProcessorRuleAccessor)((Object)getter)).getInputPredicate()), (App)RuleTest.CODEC.fieldOf("location_predicate").forGetter(entry -> ((ProcessorRuleAccessor)((Object)entry)).getLocPredicate()), (App)PAIR_CODEC.fieldOf("default_state").forGetter(entry -> Pair.of((Object)((ProcessorRuleAccessor)((Object)entry)).getOutputState(), (Object)((ProcessorRuleAccessor)((Object)entry)).getBlockEntityModifier())), (App)PAIR_CODEC.listOf().fieldOf("states").forGetter(entry -> Lists.newArrayList(entry.states))).apply((Applicative)instance, RandomBlockStateRule::new));
    private static final Random RNG = new Random();
    private final List<Pair<BlockState, RuleBlockEntityModifier>> states;

    public RandomBlockStateRule(@NotNull RuleTest inputPredicate, @NotNull RuleTest locationPredicate, BlockState defaultState, @NotNull List<BlockState> outputStates) {
        this(inputPredicate, locationPredicate, (Pair<BlockState, RuleBlockEntityModifier>)Pair.of((Object)defaultState, (Object)DEFAULT_BLOCK_ENTITY_MODIFIER), outputStates.stream().map(state -> Pair.of((Object)state, (Object)DEFAULT_BLOCK_ENTITY_MODIFIER)).collect(Collectors.toList()));
    }

    public RandomBlockStateRule(@NotNull RuleTest inputPredicate, @NotNull RuleTest locationPredicate, @NotNull Pair<BlockState, RuleBlockEntityModifier> defaultState, List<Pair<BlockState, RuleBlockEntityModifier>> states) {
        super(inputPredicate, locationPredicate, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, (BlockState)defaultState.getLeft(), (RuleBlockEntityModifier)defaultState.getRight());
        this.states = states;
    }

    public Pair<BlockState, RuleBlockEntityModifier> getOutput() {
        if (!this.states.isEmpty()) {
            int type = RNG.nextInt(this.states.size());
            return this.states.get(type);
        }
        return Pair.of((Object)((ProcessorRuleAccessor)((Object)this)).getOutputState(), (Object)((ProcessorRuleAccessor)((Object)this)).getBlockEntityModifier());
    }
}

