/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.CursedGrass;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.mixin.accessor.MultiNoiseBiomeSourceParameterListPresetAccessor;
import de.teamlapen.vampirism.modcompat.TerraBlenderCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OverworldModifications {
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean intersects(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Climate.ParameterPoint a, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Climate.ParameterPoint b) {
        return OverworldModifications.intersects(a.temperature(), b.temperature()) && OverworldModifications.intersects(a.humidity(), b.humidity()) && OverworldModifications.intersects(a.continentalness(), b.continentalness()) && OverworldModifications.intersects(a.erosion(), b.erosion()) && OverworldModifications.intersects(a.depth(), b.depth()) && OverworldModifications.intersects(a.weirdness(), b.weirdness());
    }

    private static boolean intersects(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Climate.Parameter a, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Climate.Parameter b) {
        return a.max() > b.min() && a.min() < b.max() || a.max() == a.min() && b.max() == b.min() && a.max() == b.max();
    }

    public static void addBiomesToOverworldUnsafe() {
        if (TerraBlenderCompat.areBiomesAddedViaTerraBlender()) {
            LOGGER.info("Vampirism Biomes are added via TerraBlender. Not adding them to overworld preset.");
            return;
        }
        if (!((Boolean)VampirismConfig.COMMON.addVampireForestToOverworld.get()).booleanValue()) {
            return;
        }
        final MultiNoiseBiomeSourceParameterList.Preset.SourceProvider originalParameterSourceFunction = ((MultiNoiseBiomeSourceParameterListPresetAccessor)MultiNoiseBiomeSourceParameterList.Preset.OVERWORLD).getProvider();
        MultiNoiseBiomeSourceParameterList.Preset.SourceProvider wrapperParameterSourceFunction = new MultiNoiseBiomeSourceParameterList.Preset.SourceProvider(){

            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> p_275485_) {
                Climate.ParameterList vanillaList = originalParameterSourceFunction.apply(p_275485_);
                ArrayList<Pair> biomes = new ArrayList<Pair>(vanillaList.values());
                Object[] forestPoints = new Climate.ParameterPoint[]{Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)-0.4f, (float)-0.19f), (Climate.Parameter)Climate.Parameter.span((float)0.1f, (float)0.3f), (Climate.Parameter)Climate.Parameter.span((float)-0.11f, (float)0.55f), (Climate.Parameter)Climate.Parameter.span((float)-0.375f, (float)-0.2225f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.span((float)-0.56666666f, (float)-0.05f), (float)0.0f), Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)-0.4f, (float)-0.19f), (Climate.Parameter)Climate.Parameter.span((float)0.1f, (float)0.3f), (Climate.Parameter)Climate.Parameter.span((float)-0.11f, (float)0.55f), (Climate.Parameter)Climate.Parameter.span((float)-0.375f, (float)-0.2225f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.span((float)0.05f, (float)0.4f), (float)0.0f)};
                int oldCount = biomes.size();
                int removed = 0;
                Iterator it = biomes.iterator();
                while (it.hasNext()) {
                    Pair pair = (Pair)it.next();
                    removed += ((Holder)pair.getSecond()).unwrapKey().map(arg_0 -> 1.lambda$apply$1((Climate.ParameterPoint[])forestPoints, pair, it, arg_0)).orElse(0).intValue();
                }
                LOGGER.debug("Removed a total of {} points from {}", (Object)removed, (Object)oldCount);
                LOGGER.info("Adding biome {} to ParameterPoints {} in Preset.OVERWORLD", (Object)ModBiomes.VAMPIRE_FOREST.location(), (Object)Arrays.toString(forestPoints));
                for (Object forestPoint : forestPoints) {
                    biomes.add(Pair.of((Object)forestPoint, (Object)((Holder)p_275485_.apply(ModBiomes.VAMPIRE_FOREST))));
                }
                return new Climate.ParameterList(biomes);
            }

            private static /* synthetic */ Integer lambda$apply$1(Climate.ParameterPoint[] forestPoints, Pair pair, Iterator it, ResourceKey biomeId) {
                if ("minecraft".equals(biomeId.location().getNamespace()) && Arrays.stream(forestPoints).anyMatch(p -> OverworldModifications.intersects(p, (Climate.ParameterPoint)pair.getFirst()))) {
                    it.remove();
                    LOGGER.debug("Removing biome {} from parameter point {} in overworld preset", (Object)biomeId, pair.getFirst());
                    return 1;
                }
                return 0;
            }
        };
        ((MultiNoiseBiomeSourceParameterListPresetAccessor)MultiNoiseBiomeSourceParameterList.Preset.OVERWORLD).setProvider(wrapperParameterSourceFunction);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SurfaceRules.RuleSource buildOverworldSurfaceRules() {
        SurfaceRules.BlockRuleSource cursed_earth = new SurfaceRules.BlockRuleSource(((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).defaultBlockState());
        SurfaceRules.BlockRuleSource grass = new SurfaceRules.BlockRuleSource(((CursedGrass)ModBlocks.CURSED_GRASS.get()).defaultBlockState());
        SurfaceRules.ConditionSource inVampireBiome = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.VAMPIRE_FOREST});
        SurfaceRules.RuleSource vampireForestTopLayer = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)inVampireBiome, (SurfaceRules.RuleSource)grass);
        SurfaceRules.RuleSource vampireForestBaseLayer = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)inVampireBiome, (SurfaceRules.RuleSource)cursed_earth);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{vampireForestTopLayer}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{vampireForestBaseLayer})))}))});
    }
}

