/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class LordTitles {
    private static final Component VAMPIRE_1M = Component.translatable((String)"text.vampirism.lord_title.vampire.male1");
    private static final Component VAMPIRE_2M = Component.translatable((String)"text.vampirism.lord_title.vampire.male2");
    private static final Component VAMPIRE_3M = Component.translatable((String)"text.vampirism.lord_title.vampire.male3");
    private static final Component VAMPIRE_4M = Component.translatable((String)"text.vampirism.lord_title.vampire.male4");
    private static final Component VAMPIRE_5M = Component.translatable((String)"text.vampirism.lord_title.vampire.male5");
    private static final Component VAMPIRE_1F = Component.translatable((String)"text.vampirism.lord_title.vampire.female1");
    private static final Component VAMPIRE_2F = Component.translatable((String)"text.vampirism.lord_title.vampire.female2");
    private static final Component VAMPIRE_3F = Component.translatable((String)"text.vampirism.lord_title.vampire.female3");
    private static final Component VAMPIRE_4F = Component.translatable((String)"text.vampirism.lord_title.vampire.female4");
    private static final Component VAMPIRE_5F = Component.translatable((String)"text.vampirism.lord_title.vampire.female5");
    private static final Component HUNTER_1 = Component.translatable((String)"text.vampirism.lord_title.hunter.1");
    private static final Component HUNTER_2 = Component.translatable((String)"text.vampirism.lord_title.hunter.2");
    private static final Component HUNTER_3 = Component.translatable((String)"text.vampirism.lord_title.hunter.3");
    private static final Component HUNTER_4 = Component.translatable((String)"text.vampirism.lord_title.hunter.4");
    private static final Component HUNTER_5 = Component.translatable((String)"text.vampirism.lord_title.hunter.5");
    private static final Component EMPTY = Component.literal((String)"");

    @NotNull
    public static Component getVampireTitle(int level, IPlayableFaction.TitleGender titleGender) {
        return switch (titleGender) {
            default -> throw new MatchException(null, null);
            case IPlayableFaction.TitleGender.FEMALE -> {
                switch (level) {
                    case 1: {
                        yield VAMPIRE_1F;
                    }
                    case 2: {
                        yield VAMPIRE_2F;
                    }
                    case 3: {
                        yield VAMPIRE_3F;
                    }
                    case 4: {
                        yield VAMPIRE_4F;
                    }
                    case 5: {
                        yield VAMPIRE_5F;
                    }
                }
                yield EMPTY;
            }
            case IPlayableFaction.TitleGender.MALE, IPlayableFaction.TitleGender.UNKNOWN -> {
                switch (level) {
                    case 1: {
                        yield VAMPIRE_1M;
                    }
                    case 2: {
                        yield VAMPIRE_2M;
                    }
                    case 3: {
                        yield VAMPIRE_3M;
                    }
                    case 4: {
                        yield VAMPIRE_4M;
                    }
                    case 5: {
                        yield VAMPIRE_5M;
                    }
                }
                yield EMPTY;
            }
        };
    }

    @NotNull
    public static Component getHunterTitle(int level, IPlayableFaction.TitleGender titleGender) {
        return switch (level) {
            case 1 -> HUNTER_1;
            case 2 -> HUNTER_2;
            case 3 -> HUNTER_3;
            case 4 -> HUNTER_4;
            case 5 -> HUNTER_5;
            default -> EMPTY;
        };
    }
}

