/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.function.Function;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public record ConfigCondition(@NotNull String option, @NotNull Function<ICondition.IContext, Boolean> tester) implements ICondition
{
    public static final MapCodec<ConfigCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("option").forGetter(c -> c.option)).apply((Applicative)inst, ConfigCondition::new));

    public ConfigCondition(@NotNull String option) {
        this(option, ConfigCondition.getTester(option));
    }

    public boolean test(@NotNull ICondition.IContext context) {
        return this.tester.apply(context);
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    @NotNull
    private static Function<ICondition.IContext, Boolean> getTester(@NotNull String option) {
        return switch (option) {
            case "auto_convert" -> context -> (Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get();
            case "umbrella" -> context -> (Boolean)VampirismConfig.COMMON.umbrella.get();
            default -> throw new JsonSyntaxException("Unknown config option: " + option);
        };
    }
}

