/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.items.component.AppliedOilContent;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CleanOilRecipe
extends CustomRecipe {
    public CleanOilRecipe(@NotNull CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inventory, @NotNull Level level) {
        ItemStack tool = null;
        ItemStack paper = null;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() == Items.PAPER) {
                if (paper != null) continue;
                paper = stack;
                continue;
            }
            if (AppliedOilContent.getAppliedOil(stack).isPresent()) {
                if (tool != null) {
                    return false;
                }
                tool = stack;
                continue;
            }
            return false;
        }
        return tool != null && paper != null;
    }

    @NotNull
    public ItemStack assemble(CraftingInput inventory, @NotNull HolderLookup.Provider provider) {
        ItemStack tool = ItemStack.EMPTY;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !AppliedOilContent.getAppliedOil(stack).isPresent()) continue;
            tool = stack;
            break;
        }
        ItemStack result = tool.copy();
        AppliedOilContent.remove(result);
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CLEAN_OIL.get();
    }
}

