/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable Either<Integer, BlockPos> target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundToggleActionPacket> TYPE = new CustomPacketPayload.Type(VResourceLocation.mod("toggle_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundToggleActionPacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ServerboundToggleActionPacket::actionId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)BlockPos.STREAM_CODEC)), pkt -> Optional.ofNullable(pkt.target), ServerboundToggleActionPacket::new);

    private ServerboundToggleActionPacket(ResourceLocation action, Optional<Either<Integer, BlockPos>> target) {
        this(action, (Either<Integer, BlockPos>)((Either)target.orElse(null)));
    }

    public ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable Integer target) {
        this(actionId, (Either<Integer, BlockPos>)Either.left((Object)target));
    }

    public ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable BlockPos target) {
        this(actionId, (Either<Integer, BlockPos>)Either.right((Object)target));
    }

    public ServerboundToggleActionPacket(ResourceLocation actionId) {
        this(actionId, (Either<Integer, BlockPos>)((Either)null));
    }

    @NotNull
    public static ServerboundToggleActionPacket createFromRaytrace(ResourceLocation action, @Nullable HitResult traceResult) {
        if (traceResult != null) {
            if (traceResult.getType() == HitResult.Type.ENTITY) {
                return new ServerboundToggleActionPacket(action, ((EntityHitResult)traceResult).getEntity().getId());
            }
            if (traceResult.getType() == HitResult.Type.BLOCK) {
                return new ServerboundToggleActionPacket(action, ((BlockHitResult)traceResult).getBlockPos());
            }
        }
        return new ServerboundToggleActionPacket(action);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

