/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public record ServerboundSelectMinionTaskPacket(int minionID, ResourceLocation taskID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSelectMinionTaskPacket> TYPE = new CustomPacketPayload.Type(VResourceLocation.mod("select_minion_task"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSelectMinionTaskPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ServerboundSelectMinionTaskPacket::minionID, (StreamCodec)ResourceLocation.STREAM_CODEC, ServerboundSelectMinionTaskPacket::taskID, ServerboundSelectMinionTaskPacket::new);
    public static final ResourceLocation RECALL = VResourceLocation.mod("recall");
    public static final ResourceLocation RESPAWN = VResourceLocation.mod("respawn");

    public ServerboundSelectMinionTaskPacket {
        assert (minionID >= -1);
    }

    public static void printRecoveringMinions(@NotNull ServerPlayer player, @NotNull List<MutableComponent> recoveringMinions) {
        if (recoveringMinions.size() == 1) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.minion_is_still_recovering", (Object[])new Object[]{recoveringMinions.getFirst()}), true);
        } else if (recoveringMinions.size() > 1) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.n_minions_are_still_recovering", (Object[])new Object[]{recoveringMinions.size()}), true);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

