/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.util.ByteBufferCodecUtil;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.BossEvent;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public record ClientboundUpdateMultiBossEventPacket(Operation operation) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundUpdateMultiBossEventPacket> TYPE = new CustomPacketPayload.Type(VResourceLocation.mod("update_multi_boss_event"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateMultiBossEventPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateMultiBossEventPacket>(){

        @NotNull
        public ClientboundUpdateMultiBossEventPacket decode(RegistryFriendlyByteBuf p_320376_) {
            OperationType operationType = (OperationType)p_320376_.readEnum(OperationType.class);
            Operation operation = (Operation)operationType.streamCodec.decode((Object)p_320376_);
            return new ClientboundUpdateMultiBossEventPacket(operation);
        }

        public void encode(RegistryFriendlyByteBuf buffer, ClientboundUpdateMultiBossEventPacket packet) {
            buffer.writeEnum((Enum)packet.operation.getType());
            packet.operation.getType().codec().encode((Object)buffer, (Object)packet.operation);
        }
    };

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static interface Operation {
        public OperationType getType();

        public UUID uniqueId();
    }

    public static enum OperationType {
        ADD(AddOperation.CODEC),
        REMOVE(RemoveOperation.CODEC),
        UPDATE_PROGRESS(UpdateProgressOperation.CODEC),
        UPDATE_NAME(UpdateNameOperation.CODEC),
        UPDATE_STYLE(UpdateStyle.CODEC);

        private final StreamCodec<RegistryFriendlyByteBuf, ? extends Operation> streamCodec;

        private OperationType(StreamCodec<RegistryFriendlyByteBuf, ? extends Operation> streamCodec) {
            this.streamCodec = streamCodec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Operation> codec() {
            return this.streamCodec;
        }
    }

    public record UpdateStyle(UUID uniqueId, BossEvent.BossBarOverlay overlay) implements Operation
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, UpdateStyle> CODEC = StreamCodec.composite(ByteBufferCodecUtil.UUID, UpdateStyle::uniqueId, (StreamCodec)NeoForgeStreamCodecs.enumCodec(BossEvent.BossBarOverlay.class), UpdateStyle::overlay, UpdateStyle::new);

        public UpdateStyle(MultiBossEvent event) {
            this(event.getUniqueId(), event.getOverlay());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_STYLE;
        }
    }

    public record UpdateNameOperation(UUID uniqueId, Component name) implements Operation
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, UpdateNameOperation> CODEC = StreamCodec.composite(ByteBufferCodecUtil.UUID, UpdateNameOperation::uniqueId, (StreamCodec)ComponentSerialization.STREAM_CODEC, UpdateNameOperation::name, UpdateNameOperation::new);

        public UpdateNameOperation(MultiBossEvent event) {
            this(event.getUniqueId(), event.getName());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_NAME;
        }
    }

    public record UpdateProgressOperation(UUID uniqueId, Map<Color, Float> entries) implements Operation
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, UpdateProgressOperation> CODEC = StreamCodec.composite(ByteBufferCodecUtil.UUID, UpdateProgressOperation::uniqueId, (StreamCodec)ByteBufCodecs.map(s -> new HashMap(), Color.STREAM_CODEC, (StreamCodec)ByteBufCodecs.FLOAT), UpdateProgressOperation::entries, UpdateProgressOperation::new);

        public UpdateProgressOperation(MultiBossEvent event) {
            this(event.getUniqueId(), event.getEntries());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROGRESS;
        }
    }

    public record RemoveOperation(UUID uniqueId) implements Operation
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, RemoveOperation> CODEC = StreamCodec.composite(ByteBufferCodecUtil.UUID, RemoveOperation::uniqueId, RemoveOperation::new);

        public RemoveOperation(MultiBossEvent event) {
            this(event.getUniqueId());
        }

        @Override
        public OperationType getType() {
            return OperationType.REMOVE;
        }
    }

    public record AddOperation(UUID uniqueId, List<Color> colors, Map<Color, Float> entries, Component name, BossEvent.BossBarOverlay overlay) implements Operation
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, AddOperation> CODEC = StreamCodec.composite(ByteBufferCodecUtil.UUID, AddOperation::uniqueId, (StreamCodec)Color.STREAM_CODEC.apply(ByteBufCodecs.list()), AddOperation::colors, (StreamCodec)ByteBufCodecs.map(s -> new HashMap(), Color.STREAM_CODEC, (StreamCodec)ByteBufCodecs.FLOAT), AddOperation::entries, (StreamCodec)ComponentSerialization.STREAM_CODEC, AddOperation::name, (StreamCodec)NeoForgeStreamCodecs.enumCodec(BossEvent.BossBarOverlay.class), AddOperation::overlay, AddOperation::new);

        public AddOperation(MultiBossEvent event) {
            this(event.getUniqueId(), event.getColors(), event.getEntries(), event.getName(), event.getOverlay());
        }

        @Override
        public OperationType getType() {
            return OperationType.ADD;
        }
    }
}

