/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.util.Arrays;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TaskRecipeCategory
implements IRecipeCategory<Task> {
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public TaskRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(VResourceLocation.loc("jei", "textures/jei/atlas/gui/slot.png"), 0, 0, 18, 18).setTextureSize(18, 18).addPadding(14, 90, 75, 75).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.VAMPIRE_FANG.get()));
        this.guiHelper = guiHelper;
    }

    public void draw(@NotNull Task task, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        int x = 4;
        int y = 40;
        graphics.drawString(minecraft.font, task.getTitle(), 1, 1, Color.GRAY.getRGB(), false);
        Registry tasks = minecraft.level.registryAccess().registryOrThrow(VampirismRegistries.Keys.TASK);
        Component taskmasterComponent = (Component)Arrays.stream(VampirismAPI.factionRegistry().getFactions()).filter(s -> s.getTag(VampirismRegistries.Keys.TASK).filter(t -> tasks.wrapAsHolder((Object)task).is(t)).isPresent()).map(a -> a.getVillageData().getTaskMasterEntity()).filter(Objects::nonNull).map(EntityType::getDescriptionId).map(Component::translatable).reduce((comp1, comp2) -> comp1.append(", ").append((Component)comp2)).orElse(Component.translatable((String)"text.vampirism.faction_representative"));
        MutableComponent text = Component.translatable((String)"text.vampirism.task.reward_obtain", (Object[])new Object[]{taskmasterComponent});
        y += UtilLib.renderMultiLine(minecraft.font, graphics, (Component)text, 160, x, y, Color.GRAY.getRGB());
        MutableComponent prerequisites = Component.translatable((String)"text.vampirism.task.prerequisites").append(":\n");
        TaskUnlocker[] unlockers = task.getUnlocker();
        if (unlockers.length > 0) {
            MutableComponent newLine = Component.literal((String)"\n");
            for (TaskUnlocker u : unlockers) {
                prerequisites.append((Component)Component.literal((String)"- ")).append(u.getDescription()).append((Component)newLine);
            }
        } else {
            prerequisites.append((Component)Component.translatable((String)"text.vampirism.task.prerequisites.none"));
        }
        y += UtilLib.renderMultiLine(minecraft.font, graphics, (Component)prerequisites, 160, x, y, Color.GRAY.getRGB());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"text.vampirism.task.reward");
    }

    @NotNull
    public RecipeType<Task> getRecipeType() {
        return VampirismJEIPlugin.TASK;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Task recipe, @NotNull IFocusGroup focuses) {
        TaskReward reward = recipe.getReward();
        if (reward instanceof ItemReward) {
            ItemReward itemReward = (ItemReward)reward;
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 15);
            output.addItemStacks(itemReward.getAllPossibleRewards());
        }
    }
}

