/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.PotionTableBlock;
import de.teamlapen.vampirism.client.gui.screens.PotionTableScreen;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PotionTableRecipeCategory
implements IRecipeCategory<JEIPotionMix> {
    @NotNull
    private final Component localizedName = Component.translatable((String)((PotionTableBlock)((Object)ModBlocks.POTION_TABLE.get())).getDescriptionId());
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    private final IDrawable slotDrawable;
    @NotNull
    private final IDrawable arrow;
    @NotNull
    private final IDrawable bubbles;
    @NotNull
    private final IDrawable blazeHeat;

    PotionTableRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.POTION_TABLE.get()));
        this.background = guiHelper.drawableBuilder(PotionTableScreen.BACKGROUND, 65, 6, 103, 73).addPadding(0, 33, 0, 25).build();
        this.slotDrawable = guiHelper.getSlotDrawable();
        IDrawableStatic bubbles = guiHelper.drawableBuilder(PotionTableRecipeCategory.fixSprite(PotionTableScreen.BUBBLES_SPRITE), 0, 0, 12, 29).setTextureSize(12, 29).build();
        this.bubbles = guiHelper.createAnimatedDrawable(bubbles, 400, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic blaze = guiHelper.drawableBuilder(PotionTableRecipeCategory.fixSprite(PotionTableScreen.FUEL_SPRITE), 0, 0, 18, 4).setTextureSize(18, 4).build();
        this.blazeHeat = guiHelper.createAnimatedDrawable(blaze, 400, IDrawableAnimated.StartDirection.LEFT, false);
        IDrawableStatic progress = guiHelper.drawableBuilder(PotionTableRecipeCategory.fixSprite(PotionTableScreen.PROGRESS_SPRITE), 0, 0, 9, 28).setTextureSize(9, 28).build();
        this.arrow = guiHelper.createAnimatedDrawable(progress, 400, IDrawableAnimated.StartDirection.TOP, false);
    }

    private static ResourceLocation fixSprite(ResourceLocation spriteLoc) {
        return spriteLoc.withPrefix("textures/gui/sprites/").withSuffix(".png");
    }

    public void draw(@NotNull JEIPotionMix recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        this.blazeHeat.draw(graphics, 1, 35);
        this.bubbles.draw(graphics, 3, 4);
        this.arrow.draw(graphics, 80, 10);
        int y = 75;
        int x = 5;
        Minecraft minecraft = Minecraft.getInstance();
        if (recipe.getOriginal().durable && recipe.getOriginal().concentrated) {
            graphics.drawString(minecraft.font, (Component)((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9;
        } else if (recipe.getOriginal().durable) {
            graphics.drawString(minecraft.font, (Component)((ISkill)HunterSkills.DURABLE_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9;
        } else if (recipe.getOriginal().concentrated) {
            graphics.drawString(minecraft.font, (Component)((ISkill)HunterSkills.CONCENTRATED_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9;
        }
        if (recipe.getOriginal().master) {
            graphics.drawString(minecraft.font, (Component)((ISkill)HunterSkills.MASTER_BREWER.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9;
        }
        if (recipe.getOriginal().efficient) {
            graphics.drawString(minecraft.font, (Component)((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.font);
            y += 9;
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public RecipeType<JEIPotionMix> getRecipeType() {
        return VampirismJEIPlugin.POTION;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull JEIPotionMix recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 39, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 83, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 2).addItemStacks(recipe.getMix1());
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 10).addItemStacks(recipe.getMix2());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 15).addItemStack(recipe.getPotionOutput())).setBackground(this.slotDrawable, -1, -1);
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        @NotNull
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(@NotNull IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }
    }
}

