/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Streams;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.items.VampirismSwordItem;
import de.teamlapen.vampirism.items.component.BloodCharged;
import de.teamlapen.vampirism.items.component.SwordTraining;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.ToolMaterial;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampireSwordItem
extends VampirismSwordItem
implements IBloodChargeable,
IFactionExclusiveItem,
IFactionLevelItem<IVampirePlayer> {
    private final float trainedAttackSpeedIncrease;

    public VampireSwordItem(@NotNull VampireSwordMaterial material, int attackDamage, @NotNull Item.Properties prop) {
        super((Tier)material, attackDamage, material.getSpeed(), prop);
        this.trainedAttackSpeedIncrease = material.getTrainedSpeedIncrease();
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        float charged = this.getChargePercentage(stack);
        float trained = this.getTrained(stack, (LivingEntity)VampirismMod.proxy.getClientPlayer());
        tooltip.add((Component)Component.translatable((String)"text.vampirism.sword_charged").append((Component)Component.literal((String)(" " + (int)Math.ceil(charged * 100.0f) + "%"))).withStyle(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.translatable((String)"text.vampirism.sword_trained").append((Component)Component.literal((String)(" " + (int)Math.ceil(trained * 100.0f) + "%"))).withStyle(ChatFormatting.DARK_AQUA));
        super.appendHoverText(stack, context, tooltip, flagIn);
        this.addFactionToolTips(stack, context, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    @Override
    public boolean canBeCharged(@NotNull ItemStack stack) {
        return this.getChargePercentage(stack) < 1.0f;
    }

    @Override
    public int charge(@NotNull ItemStack stack, int amount) {
        float factor = this.getChargingFactor(stack);
        float charge = this.getChargePercentage(stack);
        float actual = Math.min(factor * (float)amount, 1.0f - charge);
        this.setCharged(stack, charge + actual);
        return (int)(actual / factor);
    }

    public void doNotName(@NotNull ItemStack stack) {
        stack.set(ModDataComponents.DO_NOT_NAME, (Object)Unit.INSTANCE);
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public ISkill<IVampirePlayer> getRequiredSkill(@NotNull ItemStack stack) {
        return null;
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity p_344979_) {
        return 40;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        VReference.VAMPIRE_FACTION.getPlayerCapability((Player)entityLiving).ifPresent(vampire -> {
            int amount;
            int n = amount = vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.BLOOD_CHARGE_SPEED.get()) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2;
            if (((Player)entityLiving).isCreative() || vampire.useBlood(amount, false)) {
                this.charge(stack, amount * 100);
            }
        });
        if (this.getChargePercentage(stack) == 1.0f) {
            this.tryName(stack, (Player)entityLiving);
        }
        return stack;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!Helper.isVampire((Entity)target) && !target.getType().is(ModTags.Entities.IGNORE_VAMPIRE_SWORD_FINISHER)) {
                ISkillHandler<IVampirePlayer> skillHandler = VampirePlayer.get(player).getSkillHandler();
                double relTh = (Double)VampirismConfig.BALANCE.vsSwordFinisherMaxHealth.get() * (skillHandler.isSkillEnabled((ISkill)VampireSkills.SWORD_FINISHER.get()) ? (skillHandler.isRefinementEquipped((IRefinement)ModRefinements.SWORD_FINISHER.get()) ? (Double)VampirismConfig.BALANCE.vrSwordFinisherThresholdMod.get() : 1.0) : 0.0);
                List<IItemWithTier.TIER> hunterCoatArmor = Streams.stream((Iterable)target.getArmorSlots()).filter(s -> s.getItem() instanceof HunterCoatItem).map(s -> ((HunterCoatItem)s.getItem()).getVampirismTier()).toList();
                if (hunterCoatArmor.size() == 4) {
                    IItemWithTier.TIER level = hunterCoatArmor.stream().min(Comparator.comparingInt(Enum::ordinal)).orElse(IItemWithTier.TIER.NORMAL);
                    relTh *= (double)(1.0f - (switch (level) {
                        default -> throw new MatchException(null, null);
                        case IItemWithTier.TIER.NORMAL -> 0.25f;
                        case IItemWithTier.TIER.ENHANCED -> 0.3f;
                        case IItemWithTier.TIER.ULTIMATE -> 0.35f;
                    }));
                }
                if (relTh > 0.0 && (double)target.getHealth() <= (double)target.getMaxHealth() * relTh) {
                    DamageHandler.hurtModded((Entity)target, s -> s.getPlayerAttackWithBypassArmor(player), 10000.0f);
                    Vec3 center = Vec3.atLowerCornerOf((Vec3i)target.blockPosition());
                    center.add(0.0, (double)target.getBbHeight() / 2.0, 0.0);
                    ModParticles.spawnParticlesServer(target.level(), new GenericParticleOptions(VResourceLocation.mc("effect_4"), 12, 0xE02020), center.x, center.y, center.z, 15, 0.5, 0.5, 0.5, 0.0);
                }
            }
        }
        if (target.getHealth() <= 0.0f && Helper.isVampire((Entity)attacker)) {
            Level level;
            int n;
            float trained = this.getTrained(stack, attacker);
            if (target instanceof Player) {
                n = 10;
            } else if (attacker instanceof Player && (level = attacker.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                n = target.getExperienceReward(serverLevel, (Entity)attacker);
            } else {
                n = 5;
            }
            int exp = n;
            float newTrained = (float)exp / 5.0f * (1.0f - trained) / 15.0f;
            if (attacker instanceof Player && VampirePlayer.get((Player)attacker).getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SWORD_TRAINED_AMOUNT.get())) {
                newTrained = (float)((double)newTrained * (Double)VampirismConfig.BALANCE.vrSwordTrainingSpeedMod.get());
            }
            this.setTrained(stack, attacker, trained += newTrained);
        }
        float charged = this.getChargePercentage(stack);
        this.setCharged(stack, charged -= this.getChargeUsage());
        attacker.setItemInHand(InteractionHand.MAIN_HAND, stack);
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isFullyCharged(@NotNull ItemStack stack) {
        return this.getChargePercentage(stack) == 1.0f;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !Helper.isVampire((Entity)entity);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        float charged;
        if (worldIn.isClientSide && (isSelected || itemSlot == 0) && (charged = this.getChargePercentage(stack)) > 0.0f && entityIn.tickCount % (int)(20.0f + 100.0f * (1.0f - charged)) == 0 && entityIn instanceof LivingEntity) {
            boolean secondHand;
            boolean bl = secondHand = !isSelected && ((LivingEntity)entityIn).getItemInHand(InteractionHand.OFF_HAND).equals(stack);
            if (isSelected || secondHand) {
                this.spawnChargedParticle((LivingEntity)entityIn, isSelected);
            }
        }
    }

    public void onUseTick(Level level, @NotNull LivingEntity player, ItemStack stack, int count) {
        if (player.getCommandSenderWorld().isClientSide && count % 3 == 0) {
            this.spawnChargingParticle(player, player.getMainHandItem().equals(stack));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return !Helper.isVampire(player);
    }

    public void setCharged(@NotNull ItemStack stack, float value) {
        stack.set(ModDataComponents.BLOOD_CHARGED, (Object)((BloodCharged)stack.getOrDefault(ModDataComponents.BLOOD_CHARGED, (Object)BloodCharged.EMPTY)).charged(value));
    }

    public void setTrained(@NotNull ItemStack stack, @NotNull LivingEntity player, float value) {
        stack.set(ModDataComponents.VAMPIRE_SWORD, (Object)((SwordTraining)stack.getOrDefault(ModDataComponents.VAMPIRE_SWORD, (Object)SwordTraining.EMPTY)).addTraining(player.getUUID(), value));
    }

    public void tryName(@NotNull ItemStack stack, @NotNull Player player) {
        if (!stack.has(DataComponents.CUSTOM_NAME) && player.level().isClientSide() && !stack.has(ModDataComponents.DO_NOT_NAME)) {
            VampirismMod.proxy.displayNameSwordScreen(stack);
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public boolean updateTrainedCached(@NotNull ItemStack stack, @NotNull LivingEntity player) {
        float trained;
        float cached = this.getTrained(stack);
        if (cached != (trained = this.getTrained(stack, player))) {
            stack.set(ModDataComponents.TRAINING_CACHE, (Object)Float.valueOf(trained));
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        VampirePlayer vampire = VampirePlayer.get(playerIn);
        if (vampire.getLevel() == 0) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (this.canBeCharged(stack) && playerIn.isShiftKeyDown() && vampire.getSkillHandler().isSkillEnabled((ISkill)VampireSkills.BLOOD_CHARGE.get()) && (playerIn.isCreative() || vampire.getBloodLevel() >= (vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.BLOOD_CHARGE_SPEED.get()) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2))) {
            playerIn.startUsingItem(handIn);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    protected float getAttackDamageModifier(@NotNull ItemStack stack) {
        return this.getChargePercentage(stack) > 0.0f ? 0.8f : 0.0f;
    }

    protected float getSpeedModifier(@NotNull ItemStack stack) {
        return this.getTrained(stack) * this.trainedAttackSpeedIncrease;
    }

    protected abstract float getChargeUsage();

    @Override
    public float getChargePercentage(@NotNull ItemStack stack) {
        return ((BloodCharged)stack.getOrDefault(ModDataComponents.BLOOD_CHARGED, (Object)BloodCharged.EMPTY)).charged();
    }

    protected abstract float getChargingFactor(ItemStack var1);

    protected float getTrained(@NotNull ItemStack stack) {
        return ((Float)stack.getOrDefault(ModDataComponents.TRAINING_CACHE, (Object)Float.valueOf(0.0f))).floatValue();
    }

    protected float getTrained(@NotNull ItemStack stack, @Nullable LivingEntity player) {
        if (player == null) {
            return this.getTrained(stack);
        }
        return ((SwordTraining)stack.getOrDefault(ModDataComponents.VAMPIRE_SWORD, (Object)SwordTraining.EMPTY)).training().getOrDefault(player.getUUID(), Float.valueOf(0.0f)).floatValue();
    }

    private void spawnChargedParticle(@NotNull LivingEntity player, boolean mainHand) {
        Vec3 mainPos = UtilLib.getItemPosition(player, mainHand);
        for (int j = 0; j < 3; ++j) {
            Vec3 pos = mainPos.add((double)((player.getRandom().nextFloat() - 0.5f) * 0.1f), (double)((player.getRandom().nextFloat() - 0.3f) * 0.9f), (double)((player.getRandom().nextFloat() - 0.5f) * 0.1f));
            ModParticles.spawnParticleClient(player.getCommandSenderWorld(), new FlyingBloodParticleOptions((int)(4.0f / (player.getRandom().nextFloat() * 0.9f + 0.1f)), true, pos.x + ((double)player.getRandom().nextFloat() - 0.5) * 0.1, pos.y + ((double)player.getRandom().nextFloat() - 0.5) * 0.1, pos.z + ((double)player.getRandom().nextFloat() - 0.5) * 0.1, VResourceLocation.mc("glitter_1")), pos.x, pos.y, pos.z);
        }
    }

    private void spawnChargingParticle(@NotNull LivingEntity player, boolean mainHand) {
        Vec3 pos = UtilLib.getItemPosition(player, mainHand);
        if (player.getAttackAnim(1.0f) > 0.0f) {
            return;
        }
        pos = pos.add((double)((player.getRandom().nextFloat() - 0.5f) * 0.1f), (double)((player.getRandom().nextFloat() - 0.3f) * 0.9f), (double)((player.getRandom().nextFloat() - 0.5f) * 0.1f));
        Vec3 playerPos = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight() - (double)0.2f, player.getZ());
        ModParticles.spawnParticleClient(player.getCommandSenderWorld(), new FlyingBloodParticleOptions((int)(4.0f / (player.getRandom().nextFloat() * 0.6f + 0.1f)), true, pos.x, pos.y, pos.z), playerPos.x, playerPos.y, playerPos.z);
    }

    public static class VampireSwordMaterial
    extends ToolMaterial.Tiered {
        private final float trainedSpeedIncrease;

        public VampireSwordMaterial(IItemWithTier.TIER tier, TagKey<Block> incorrectTier, int uses, float speed, float damage, int enchantmentValue, Supplier<Ingredient> repairIngredient, float trainedSpeedIncrease) {
            super(tier, incorrectTier, uses, speed, damage, enchantmentValue, repairIngredient);
            this.trainedSpeedIncrease = trainedSpeedIncrease;
        }

        public float getTrainedSpeedIncrease() {
            return this.trainedSpeedIncrease;
        }
    }
}

