/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.blocks.HolyWaterEffectConsumer;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.items.HolyWaterBottleItem;
import de.teamlapen.vampirism.util.DamageHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HolyWaterSplashBottleItem
extends HolyWaterBottleItem
implements ThrowableItemEntity.IVampirismThrowableItem {
    public HolyWaterSplashBottleItem(IItemWithTier.TIER tier) {
        super(tier, new Item.Properties());
    }

    @Override
    public void onImpact(@NotNull ThrowableItemEntity entity, ItemStack stack, @NotNull HitResult result, boolean remote) {
        if (!remote) {
            this.impactEntities(entity, stack, result, remote);
            this.impactBlocks(entity, stack, result, remote);
            entity.getCommandSenderWorld().levelEvent(2002, entity.blockPosition(), PotionContents.getColor((Holder)Potions.MUNDANE));
        }
    }

    protected void impactEntities(@NotNull ThrowableItemEntity bottleEntity, ItemStack stack, @NotNull HitResult result, boolean remote) {
        AABB impactArea = bottleEntity.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list1 = bottleEntity.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, impactArea);
        @Nullable Entity thrower = bottleEntity.getOwner();
        if (!list1.isEmpty()) {
            for (LivingEntity entity : list1) {
                if (thrower instanceof Player) {
                    Player target;
                    Player source = (Player)thrower;
                    if (entity instanceof Player && !source.canHarmPlayer(target = (Player)entity)) continue;
                }
                DamageHandler.affectEntityHolyWaterSplash(entity, this.getStrength(this.getVampirismTier()), bottleEntity.distanceToSqr((Entity)entity), result.getType() == HitResult.Type.ENTITY, thrower instanceof LivingEntity ? (LivingEntity)thrower : null);
            }
        }
    }

    protected void impactBlocks(@NotNull ThrowableItemEntity bottleEntity, ItemStack stack, @NotNull HitResult result, boolean remote) {
        int size = switch (this.getVampirismTier()) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> 1;
            case IItemWithTier.TIER.ENHANCED -> 2;
            case IItemWithTier.TIER.ULTIMATE -> 3;
        };
        AABB impactArea = bottleEntity.getBoundingBox().inflate((double)size);
        Level level = bottleEntity.getCommandSenderWorld();
        UtilLib.forEachBlockPos(impactArea, pos -> {
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof HolyWaterEffectConsumer) {
                HolyWaterEffectConsumer consumer = (HolyWaterEffectConsumer)block;
                consumer.onHolyWaterEffect(level, state, (BlockPos)pos, stack, this.getVampirismTier());
            }
        });
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (playerIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            ThrowableItemEntity entityThrowable = new ThrowableItemEntity(worldIn, (LivingEntity)playerIn);
            ItemStack throwStack = stack.copy();
            throwStack.setCount(1);
            entityThrowable.setItem(throwStack);
            entityThrowable.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), -20.0f, 0.5f, 1.0f);
            worldIn.addFreshEntity((Entity)entityThrowable);
        }
        if (!playerIn.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

