/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.mixin.accessor.EntityAccessor;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucifixItem
extends Item
implements IItemWithTier,
IFactionExclusiveItem,
IFactionLevelItem<IHunterPlayer> {
    private static final String baseRegName = "crucifix";
    private final IItemWithTier.TIER tier;
    private static final Set<CrucifixItem> all_crucifix = Collections.synchronizedSet(new HashSet());

    public CrucifixItem(IItemWithTier.TIER tier) {
        super(new Item.Properties().stacksTo(1));
        this.tier = tier;
        all_crucifix.add(this);
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return 1;
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(@NotNull ItemStack stack) {
        if (this.tier == IItemWithTier.TIER.ULTIMATE) {
            return (ISkill)HunterSkills.ULTIMATE_CRUCIFIX.get();
        }
        return (ISkill)HunterSkills.CRUCIFIX_WIELDER.get();
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack p_77661_1_) {
        return UseAnim.NONE;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        this.addFactionToolTips(stack, context, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        Helper.handleHeldNonVampireItem(stack, entity, held);
    }

    protected boolean affectsEntity(@NotNull LivingEntity e) {
        return e.getType().is(EntityTypeTags.UNDEAD) || Helper.isVampire((Entity)e);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof Player) {
            all_crucifix.forEach(item -> ((Player)entity).getCooldowns().addCooldown((Item)item, this.getCooldown(stack)));
        }
    }

    protected int getCooldown(ItemStack stack) {
        return switch (this.tier) {
            case IItemWithTier.TIER.ENHANCED -> 100;
            case IItemWithTier.TIER.ULTIMATE -> 60;
            default -> 140;
        };
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 72000;
    }

    protected static int determineEntityTier(LivingEntity e) {
        if (e instanceof Player) {
            int level = VampirismPlayerAttributes.get((Player)((Player)e)).vampireLevel;
            int tier = 1;
            if (level == VReference.VAMPIRE_FACTION.getHighestReachableLevel()) {
                tier = 3;
            } else if (level >= 8) {
                tier = 2;
            }
            if (VampirePlayer.get((Player)e).getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.CRUCIFIX_RESISTANT.get())) {
                ++tier;
            }
            return tier;
        }
        if (e instanceof VampireBaronEntity) {
            return 3;
        }
        if (e instanceof AdvancedVampireEntity) {
            return 2;
        }
        return 1;
    }

    protected double determineSlowdown(int entityTier) {
        return switch (this.tier) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> {
                if (entityTier > 1) {
                    yield 0.1;
                }
                yield 0.5;
            }
            case IItemWithTier.TIER.ENHANCED -> {
                if (entityTier > 2) {
                    yield 0.1;
                }
                yield 0.5;
            }
            case IItemWithTier.TIER.ULTIMATE -> entityTier > 3 ? 0.3 : 0.5;
        };
    }

    protected int getRange(ItemStack stack) {
        return switch (this.tier) {
            case IItemWithTier.TIER.ENHANCED -> 8;
            case IItemWithTier.TIER.ULTIMATE -> 10;
            default -> 4;
        };
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int count) {
        for (LivingEntity nearbyEntity : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.forCombat().selector(this::affectsEntity), entity, entity.getBoundingBox().inflate((double)this.getRange(stack)))) {
            double scale;
            Vec3 oldDelta;
            Vec3 horizontalDelta;
            Vec3 baseVector = entity.position().subtract(nearbyEntity.position()).multiply(1.0, 0.0, 1.0).normalize();
            double parallelScale = baseVector.dot(horizontalDelta = (oldDelta = nearbyEntity.getDeltaMovement()).multiply(1.0, 0.0, 1.0));
            if (!(parallelScale > 0.0)) continue;
            Vec3 parallelPart = baseVector.scale(parallelScale);
            Vec3 newDelta = oldDelta.subtract(parallelPart.scale(scale = this.determineSlowdown(CrucifixItem.determineEntityTier(nearbyEntity))));
            if (newDelta.lengthSqr() > oldDelta.lengthSqr()) {
                newDelta = Vec3.ZERO;
            }
            Vec3 collisionDelta = ((EntityAccessor)nearbyEntity).invoke_collide(newDelta);
            if (collisionDelta.y != newDelta.y && newDelta.y < 0.0) {
                newDelta = newDelta.multiply(1.0, 0.0, 1.0);
            }
            nearbyEntity.setDeltaMovement(newDelta);
        }
    }
}

