/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TaskMenu {
    public boolean areRequirementsCompleted(@NotNull ITaskInstance var1, @NotNull TaskRequirement.Type var2);

    public TaskAction buttonAction(@NotNull ITaskInstance var1);

    public boolean canCompleteTask(@NotNull ITaskInstance var1);

    public TextColor getFactionColor();

    public int getRequirementStatus(@NotNull ITaskInstance var1, @NotNull TaskRequirement.Requirement<?> var2);

    public boolean isCompleted(@NotNull ITaskInstance var1);

    public boolean isRequirementCompleted(@NotNull ITaskInstance var1, @NotNull TaskRequirement.Requirement<?> var2);

    default public boolean isTaskNotAccepted(@NotNull ITaskInstance taskInfo) {
        return !taskInfo.isAccepted();
    }

    public void pressButton(@NotNull ITaskInstance var1);

    public void setReloadListener(@Nullable Runnable var1);

    public Registry<Task> getRegistry();

    default public Task getTask(ResourceKey<Task> key) {
        return (Task)this.getRegistry().getOrThrow(key);
    }

    public static enum TaskAction implements StringRepresentable
    {
        COMPLETE("complete", "gui.vampirism.taskmaster.complete_task"),
        ACCEPT("accept", "gui.vampirism.taskmaster.accept_task"),
        ABORT("abort", "gui.vampirism.taskmaster.abort_task"),
        REMOVE("remove", "gui.vampirism.taskmaster.remove_task");

        private final String name;
        @NotNull
        private final String translationKey;

        private TaskAction(String name, String translationKey) {
            this.name = name;
            this.translationKey = translationKey;
        }

        @NotNull
        public String getTranslationKey() {
            return this.translationKey;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

