/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.villager;

import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.items.BloodBottleItem;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Trades {
    public static final VillagerTrades.ItemListing[] converted_trades = new VillagerTrades.ItemListing[]{new VillagerTrades.EmeraldForItems((ItemLike)ModItems.HUMAN_HEART.get(), 9, 2, 2), new VillagerTrades.ItemsForEmeralds((Item)ModItems.HUMAN_HEART.get(), 3, 9, 2), new ItemsForEmeraldsTradeWithDamage(BloodBottleItem.getStackWithDamage(9), 1, 1, 20, 2)};

    public static class ItemsForEmeraldsTradeWithDamage
    implements VillagerTrades.ItemListing {
        private final ItemStack result;
        private final int emeraldAmount;
        private final int resultAmount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int givenXP) {
            this(new ItemStack((ItemLike)result), emeraldAmount, resultAmount, 12, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(new ItemStack((ItemLike)result), emeraldAmount, resultAmount, maxUses, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(result, emeraldAmount, resultAmount, maxUses, givenXP, 0.05f);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP, float priceMultiplier) {
            this.result = result;
            this.emeraldAmount = emeraldAmount;
            this.resultAmount = resultAmount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = priceMultiplier;
        }

        @NotNull
        public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
            ItemStack second = new ItemStack((ItemLike)this.result.getItem(), this.resultAmount);
            second.setDamageValue(this.result.getDamageValue());
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldAmount), second, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    public static class Price {
        private final int min;
        private final int max;

        public Price(int minIn, int maxIn) {
            this.max = maxIn;
            this.min = minIn;
        }

        int getPrice(@NotNull RandomSource rand) {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + rand.nextInt(this.max - this.min);
        }
    }

    public static class VampireForestMapTrade
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;

        public VampireForestMapTrade(int pEmeraldCost, int pMaxUses, int pVillagerXp) {
            this.emeraldCost = pEmeraldCost;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity pTrader, RandomSource pRand) {
            if (pTrader instanceof ConvertedVillagerEntity) {
                ConvertedVillagerEntity convertedVillager = (ConvertedVillagerEntity)pTrader;
                Level level = pTrader.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    return convertedVillager.getClosestVampireForest(pTrader.level(), pTrader.blockPosition()).map(blockPos -> {
                        ItemStack itemstack = MapItem.create((Level)pTrader.level(), (int)blockPos.getX(), (int)blockPos.getZ(), (byte)3, (boolean)true, (boolean)true);
                        MapItem.renderBiomePreviewMap((ServerLevel)serverLevel, (ItemStack)itemstack);
                        MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", (Holder)MapDecorationTypes.TARGET_POINT);
                        itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"biome.vampirism.vampire_forest"));
                        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), itemstack, this.maxUses, this.villagerXp, 0.2f);
                    }).orElse(null);
                }
            }
            return null;
        }
    }

    public static class BloodBottleForHeart
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final Price selling;
        private final int damage;
        private final int maxUses;

        public BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn) {
            this(priceIn, sellingIn, damageIn, 2, 8);
        }

        BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.selling = sellingIn;
            this.damage = damageIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
            ItemStack bottle = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get(), this.selling.getPrice(random));
            bottle.setDamageValue(this.damage);
            return new MerchantOffer(new ItemCost((ItemLike)ModItems.HUMAN_HEART.get(), this.price.getPrice(random)), bottle, this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForHeart
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForHeart(Price priceIn, @NotNull ItemLike sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.asItem())}, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, @NotNull ItemLike sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.asItem())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
            return new MerchantOffer(new ItemCost((ItemLike)ModItems.HUMAN_HEART.get(), this.price.getPrice(random)), new ItemStack((ItemLike)this.sellingItem[random.nextInt(this.sellingItem.length)].getItem(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForSouls
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForSouls(Price priceIn, @NotNull ItemLike sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.asItem())}, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, @NotNull ItemLike sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.asItem())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
            return new MerchantOffer(new ItemCost((ItemLike)ModItems.SOUL_ORB_VAMPIRE.get(), this.price.getPrice(random)), new ItemStack((ItemLike)this.sellingItem[random.nextInt(this.sellingItem.length)].getItem(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }
}

