/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.VampireBookLootProvider;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IAdvancedVampire;
import de.teamlapen.vampirism.api.settings.Supporter;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerModelType;
import de.teamlapen.vampirism.util.SupporterManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedVampireEntity
extends VampireBaseEntity
implements IAdvancedVampire,
IPlayerOverlay,
IEntityActionUser,
VampireBookLootProvider {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.defineId(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final int MAX_LEVEL = 1;
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    private int followingEntities = 0;
    @Nullable
    private Pair<ResourceLocation, PlayerModelType> skinDetails;
    @Nullable
    private Optional<GameProfile> skinProfile;
    @Nullable
    private String lootBookId;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.add(Attributes.MAX_HEALTH, 60.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder3 = builder2.add(Attributes.ATTACK_DAMAGE, 7.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder3.add(Attributes.MOVEMENT_SPEED, 0.285).add(Attributes.FOLLOW_RANGE, 13.0);
    }

    public AdvancedVampireEntity(EntityType<? extends AdvancedVampireEntity> type, Level world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.getRandom());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
        nbt.putInt("type", this.getEyeType());
        nbt.putString("texture", (String)this.getEntityData().get(TEXTURE));
        nbt.putString("name", (String)this.getEntityData().get(NAME));
        nbt.putInt("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.putBoolean("attack", this.attack);
        if (this.lootBookId != null) {
            nbt.putString("lootBookId", this.lootBookId);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    @NotNull
    public Optional<String> getBookLootId() {
        return Optional.ofNullable(this.lootBookId);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getVampireType() {
        return (Integer)this.getEntityData().get(TYPE);
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 0, false, false));
            }
        }
    }

    @Override
    public int getMaxFollowerCount() {
        return BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
    }

    @Override
    public int getMaxEntityLevel() {
        return 1;
    }

    @NotNull
    public Component getName() {
        String senderName = (String)this.getEntityData().get(NAME);
        return "none".equals(senderName) ? super.getName() : Component.literal((String)senderName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Optional<Pair<ResourceLocation, PlayerModelType>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            VampirismMod.proxy.obtainPlayerSkins(new GameProfile(Util.NIL_UUID, name), p -> {
                this.skinDetails = p;
            });
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @NotNull
    public Optional<GameProfile> getPlayerOverlay() {
        if (this.skinProfile == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            this.skinProfile = Optional.empty();
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(p -> {
                this.skinProfile = p;
            });
        }
        return this.skinProfile;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.getEntityData().get(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        boolean flag = super.hurt(damageSource, amount);
        if (flag && damageSource.getEntity() instanceof Player && this.random.nextInt(4) == 0) {
            this.addEffect(new MobEffectInstance(ModEffects.SUNSCREEN, 150, 2));
        }
        return flag;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tagCompund) {
        super.readAdditionalSaveData(tagCompund);
        if (tagCompund.contains("level")) {
            this.setEntityLevel(tagCompund.getInt("level"));
        }
        if (tagCompund.contains("type")) {
            this.getEntityData().set(TYPE, (Object)tagCompund.getInt("type"));
            this.getEntityData().set(NAME, (Object)tagCompund.getString("name"));
            this.getEntityData().set(TEXTURE, (Object)tagCompund.getString("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.contains("attack")) {
            this.attack = tagCompund.getBoolean("attack");
        }
        if (tagCompund.contains("lootBookId")) {
            this.lootBookId = tagCompund.getString("lootBookId");
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.setCustomName(null);
        this.villageAttributes = null;
    }

    public boolean shouldShowName() {
        return true;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        if (this.random.nextBoolean()) {
            return (int)((float)(d.avgPercLevel() * 1) / 100.0f);
        }
        return this.random.nextInt(2);
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (float)(d * 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEVEL, (Object)-1);
        builder.define(TYPE, (Object)0);
        builder.define(NAME, (Object)"none");
        builder.define(TEXTURE, (Object)"none");
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        Supporter supporter = SupporterManager.getRandomVampire(this.random);
        this.lootBookId = supporter.bookId();
        this.getEntityData().set(TYPE, (Object)AdvancedVampireEntity.createCustomisationFlag(supporter));
        this.getEntityData().set(NAME, (Object)supporter.name());
        this.getEntityData().set(TEXTURE, (Object)supporter.texture());
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    private static int createCustomisationFlag(Supporter supporter) {
        Map<String, String> appearance = supporter.appearance();
        int type = 0;
        type |= Integer.parseInt(appearance.getOrDefault("eye", "0")) & 0x3F;
        type |= (Integer.parseInt(appearance.getOrDefault("fang", "6")) & 0x3F) << 6;
        return type |= (Integer.parseInt(appearance.getOrDefault("body", "16")) & 0xFF) << 12;
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.ADVANCED_VAMPIRE_IMOB.get() : (EntityType)ModEntities.ADVANCED_VAMPIRE.get();
    }

    protected int getBaseExperienceReward() {
        this.xpReward = 10 * (1 + this.getEntityLevel());
        return super.getBaseExperienceReward();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.goalSelector.addGoal(2, new RestrictSunVampireGoal<AdvancedVampireEntity>(this));
        this.goalSelector.addGoal(3, new FleeSunVampireGoal<AdvancedVampireEntity>(this, 0.9, false));
        this.goalSelector.addGoal(3, (Goal)new FleeGarlicVampireGoal(this, 0.9, false));
        this.goalSelector.addGoal(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9, 25));
        this.goalSelector.addGoal(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 13.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new AttackVillageGoal<AdvancedVampireEntity>(this));
        this.targetSelector.addGoal(2, new DefendVillageGoal<AdvancedVampireEntity>(this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.VILLAGE)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(60.0 + BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_HEALTH_PL * (double)l);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(7.0 + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)l);
    }

    public static class IMob
    extends AdvancedVampireEntity
    implements Enemy {
        public IMob(EntityType<? extends AdvancedVampireEntity> type, Level world) {
            super(type, world);
        }
    }
}

